/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.MaterialList;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.scene.plugins.ogre.SceneMaterialLoader;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.util.PlaceholderAssets;
import com.jme3.util.xml.SAXUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SceneLoader
extends DefaultHandler
implements AssetLoader {
    private static final int DEFAULT_CAM_WIDTH = 640;
    private static final int DEFAULT_CAM_HEIGHT = 480;
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private SceneMaterialLoader materialLoader = new SceneMaterialLoader();
    private Stack<String> elementStack = new Stack();
    private AssetKey key;
    private String sceneName;
    private String folderName;
    private AssetManager assetManager;
    private MaterialList materialList;
    private Node root;
    private Node node;
    private Node entityNode;
    private Light light;
    private Camera camera;
    private CameraNode cameraNode;
    private int nodeIdx = 0;
    private static volatile int sceneIdx = 0;

    public void startDocument() {
    }

    public void endDocument() {
    }

    private void reset() {
        this.elementStack.clear();
        this.nodeIdx = 0;
        this.root = null;
        this.node = null;
        this.entityNode = null;
        this.light = null;
        this.camera = null;
        this.cameraNode = null;
    }

    private void checkTopNode(String topNode) throws SAXException {
        if (!this.elementStack.peek().equals(topNode)) {
            throw new SAXException("dotScene parse error: Expected parent node to be " + topNode);
        }
    }

    private Quaternion parseQuat(Attributes attribs) throws SAXException {
        if (attribs.getValue("x") != null) {
            float x = SAXUtil.parseFloat(attribs.getValue("x"));
            float y = SAXUtil.parseFloat(attribs.getValue("y"));
            float z = SAXUtil.parseFloat(attribs.getValue("z"));
            float w = SAXUtil.parseFloat(attribs.getValue("w"));
            return new Quaternion(x, y, z, w);
        }
        if (attribs.getValue("qx") != null) {
            float x = SAXUtil.parseFloat(attribs.getValue("qx"));
            float y = SAXUtil.parseFloat(attribs.getValue("qy"));
            float z = SAXUtil.parseFloat(attribs.getValue("qz"));
            float w = SAXUtil.parseFloat(attribs.getValue("qw"));
            return new Quaternion(x, y, z, w);
        }
        if (attribs.getValue("angle") != null) {
            float angle = SAXUtil.parseFloat(attribs.getValue("angle"));
            float axisX = SAXUtil.parseFloat(attribs.getValue("axisX"));
            float axisY = SAXUtil.parseFloat(attribs.getValue("axisY"));
            float axisZ = SAXUtil.parseFloat(attribs.getValue("axisZ"));
            Quaternion q = new Quaternion();
            q.fromAngleAxis(angle, new Vector3f(axisX, axisY, axisZ));
            return q;
        }
        float angleX = SAXUtil.parseFloat(attribs.getValue("angleX"));
        float angleY = SAXUtil.parseFloat(attribs.getValue("angleY"));
        float angleZ = SAXUtil.parseFloat(attribs.getValue("angleZ"));
        Quaternion q = new Quaternion();
        q.fromAngles(angleX, angleY, angleZ);
        return q;
    }

    private void parseLightNormal(Attributes attribs) throws SAXException {
        this.checkTopNode("light");
        if (this.light instanceof DirectionalLight) {
            ((DirectionalLight)this.light).setDirection(SAXUtil.parseVector3(attribs));
        } else if (this.light instanceof SpotLight) {
            ((SpotLight)this.light).setDirection(SAXUtil.parseVector3(attribs));
        }
    }

    private void parseLightAttenuation(Attributes attribs) throws SAXException {
        this.checkTopNode("light");
        if (this.light instanceof PointLight || this.light instanceof SpotLight) {
            float range = SAXUtil.parseFloat(attribs.getValue("range"));
            float constant = SAXUtil.parseFloat(attribs.getValue("constant"));
            float linear = SAXUtil.parseFloat(attribs.getValue("linear"));
            String quadraticStr = attribs.getValue("quadratic");
            if (quadraticStr == null) {
                quadraticStr = attribs.getValue("quadric");
            }
            float quadratic = SAXUtil.parseFloat(quadraticStr);
            if (constant == 1.0f && quadratic == 0.0f && linear > 0.0f) {
                range = 1.0f / linear;
            }
            if (this.light instanceof PointLight) {
                ((PointLight)this.light).setRadius(range);
            } else {
                ((SpotLight)this.light).setSpotRange(range);
            }
        }
    }

    private void parseLightSpotLightRange(Attributes attribs) throws SAXException {
        this.checkTopNode("light");
        float outer = SAXUtil.parseFloat(attribs.getValue("outer"));
        float inner = SAXUtil.parseFloat(attribs.getValue("inner"));
        if (!(this.light instanceof SpotLight)) {
            throw new SAXException("dotScene parse error: spotLightRange can only appear under 'spot' light elements");
        }
        SpotLight sl = (SpotLight)this.light;
        sl.setSpotInnerAngle(inner * 0.5f);
        sl.setSpotOuterAngle(outer * 0.5f);
    }

    private void parseLight(Attributes attribs) throws SAXException {
        if (this.node == null || this.node.getParent() == null) {
            throw new SAXException("dotScene parse error: light can only appear under a node");
        }
        this.checkTopNode("node");
        String lightType = SAXUtil.parseString(attribs.getValue("type"), "point");
        if (lightType.equals("point")) {
            this.light = new PointLight();
        } else if (lightType.equals("directional") || lightType.equals("sun")) {
            this.light = new DirectionalLight();
            ((DirectionalLight)this.light).setDirection(Vector3f.UNIT_Z);
        } else if (lightType.equals("spotLight") || lightType.equals("spot")) {
            this.light = new SpotLight();
        } else if (lightType.equals("omni")) {
            this.light = new AmbientLight();
        } else {
            logger.log(Level.WARNING, "No matching jME3 LightType found for OGRE LightType: {0}", lightType);
        }
        logger.log(Level.FINEST, "{0} created.", this.light);
        if (!SAXUtil.parseBool(attribs.getValue("visible"), true)) {
            // empty if block
        }
        if (this.light != null) {
            this.node.getParent().addLight(this.light);
        }
    }

    private void parseCameraClipping(Attributes attribs) throws SAXException {
        if (attribs.getValue("near") != null) {
            this.camera.setFrustumNear(SAXUtil.parseFloat(attribs.getValue("near")));
            this.camera.setFrustumFar(SAXUtil.parseFloat(attribs.getValue("far")));
        } else {
            this.camera.setFrustumNear(SAXUtil.parseFloat(attribs.getValue("nearPlaneDist")));
            this.camera.setFrustumFar(SAXUtil.parseFloat(attribs.getValue("farPlaneDist")));
        }
    }

    private void parseCamera(Attributes attribs) throws SAXException {
        float fov;
        this.camera = new Camera(640, 480);
        if (SAXUtil.parseString(attribs.getValue("projectionType"), "perspective").equals("parallel")) {
            this.camera.setParallelProjection(true);
        }
        if ((fov = SAXUtil.parseFloat(attribs.getValue("fov"), 45.0f)) < (float)Math.PI) {
            fov *= 57.295776f;
        }
        this.camera.setFrustumPerspective(fov, 1.3333334f, 1.0f, 1000.0f);
        this.cameraNode = new CameraNode(attribs.getValue("name"), this.camera);
        this.cameraNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        this.node.attachChild(this.cameraNode);
        this.node = null;
    }

    private void parseEntity(Attributes attribs) throws SAXException {
        String name = attribs.getValue("name");
        name = name == null ? "OgreEntity-" + ++this.nodeIdx : name + "-entity";
        String meshFile = attribs.getValue("meshFile");
        if (meshFile == null) {
            throw new SAXException("Required attribute 'meshFile' missing for 'entity' node");
        }
        String materialName = attribs.getValue("materialName");
        if (this.folderName != null) {
            meshFile = this.folderName + meshFile;
        }
        meshFile = meshFile + ".xml";
        this.entityNode = new Node(name);
        OgreMeshKey meshKey = new OgreMeshKey(meshFile, this.materialList);
        try {
            Spatial ogreMesh = this.assetManager.loadModel(meshKey);
            this.entityNode.attachChild(ogreMesh);
        }
        catch (AssetNotFoundException ex) {
            if (ex.getMessage().equals(meshFile)) {
                logger.log(Level.WARNING, "Cannot locate {0} for scene {1}", new Object[]{meshKey, this.key});
                Spatial model = PlaceholderAssets.getPlaceholderModel(this.assetManager);
                model.setKey(this.key);
                this.entityNode.attachChild(model);
            }
            throw ex;
        }
        this.node.attachChild(this.entityNode);
        this.node = null;
    }

    private void parseNode(Attributes attribs) throws SAXException {
        String name = attribs.getValue("name");
        if (name == null) {
            name = "OgreNode-" + ++this.nodeIdx;
        }
        Node newNode = new Node(name);
        if (this.node != null) {
            this.node.attachChild(newNode);
        }
        this.node = newNode;
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (qName.equals("scene")) {
            if (this.elementStack.size() != 0) {
                throw new SAXException("dotScene parse error: 'scene' element must be the root XML element");
            }
            String version = attribs.getValue("formatVersion");
            if (version == null || !version.equals("1.0.0") && !version.equals("1.0.1")) {
                logger.log(Level.WARNING, "Unrecognized version number in dotScene file: {0}", version);
            }
        } else if (qName.equals("nodes")) {
            if (this.root != null) {
                throw new SAXException("dotScene parse error: nodes element was specified twice");
            }
            this.root = this.sceneName == null ? new Node("OgreDotScene" + ++sceneIdx) : new Node(this.sceneName + "-scene_node");
            this.node = this.root;
        } else if (qName.equals("externals")) {
            this.checkTopNode("scene");
        } else if (qName.equals("item")) {
            this.checkTopNode("externals");
        } else if (qName.equals("file")) {
            this.checkTopNode("item");
        } else if (qName.equals("node")) {
            String curElement = this.elementStack.peek();
            if (!curElement.equals("node") && !curElement.equals("nodes")) {
                throw new SAXException("dotScene parse error: node element can only appear under 'node' or 'nodes'");
            }
            this.parseNode(attribs);
        } else if (qName.equals("property")) {
            if (this.node != null) {
                String type = attribs.getValue("type");
                String name = attribs.getValue("name");
                String data = attribs.getValue("data");
                if (type.equals("BOOL")) {
                    this.node.setUserData(name, Boolean.parseBoolean(data) || data.equals("1"));
                } else if (type.equals("FLOAT")) {
                    this.node.setUserData(name, Float.valueOf(Float.parseFloat(data)));
                } else if (type.equals("STRING")) {
                    this.node.setUserData(name, data);
                } else if (type.equals("INT")) {
                    this.node.setUserData(name, Integer.parseInt(data));
                }
            }
        } else if (qName.equals("entity")) {
            this.checkTopNode("node");
            this.parseEntity(attribs);
        } else if (qName.equals("camera")) {
            this.checkTopNode("node");
            this.parseCamera(attribs);
        } else if (qName.equals("clipping")) {
            this.checkTopNode("camera");
            this.parseCameraClipping(attribs);
        } else if (qName.equals("position")) {
            if (this.elementStack.peek().equals("node")) {
                this.node.setLocalTranslation(SAXUtil.parseVector3(attribs));
            } else if (this.elementStack.peek().equals("camera")) {
                this.cameraNode.setLocalTranslation(SAXUtil.parseVector3(attribs));
            }
        } else if (qName.equals("quaternion") || qName.equals("rotation")) {
            this.node.setLocalRotation(this.parseQuat(attribs));
        } else if (qName.equals("scale")) {
            this.node.setLocalScale(SAXUtil.parseVector3(attribs));
        } else if (qName.equals("light")) {
            this.parseLight(attribs);
        } else if (qName.equals("colourDiffuse") || qName.equals("colorDiffuse")) {
            if (this.elementStack.peek().equals("light")) {
                if (this.light != null) {
                    this.light.setColor(SAXUtil.parseColor(attribs));
                }
            } else {
                this.checkTopNode("environment");
            }
        } else if (qName.equals("colourAmbient") || qName.equals("colorAmbient")) {
            ColorRGBA color;
            if (this.elementStack.peek().equals("environment") && !(color = SAXUtil.parseColor(attribs)).equals(ColorRGBA.Black) && !color.equals(ColorRGBA.BlackNoAlpha)) {
                AmbientLight al = new AmbientLight();
                al.setColor(color);
                this.root.addLight(al);
            }
        } else if (qName.equals("normal") || qName.equals("direction")) {
            this.checkTopNode("light");
            this.parseLightNormal(attribs);
        } else if (qName.equals("lightAttenuation")) {
            this.parseLightAttenuation(attribs);
        } else if (qName.equals("spotLightRange") || qName.equals("lightRange")) {
            this.parseLightSpotLightRange(attribs);
        }
        this.elementStack.push(qName);
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (qName.equals("node")) {
            this.node = this.node.getParent();
        } else if (qName.equals("nodes")) {
            this.node = null;
        } else if (qName.equals("entity")) {
            this.node = this.entityNode.getParent();
            this.entityNode = null;
        } else if (qName.equals("camera")) {
            this.node = this.cameraNode.getParent();
            this.cameraNode = null;
        } else if (qName.equals("light")) {
            this.root.updateGeometricState();
            if (this.light != null) {
                if (this.light instanceof DirectionalLight) {
                    DirectionalLight dl = (DirectionalLight)this.light;
                    Quaternion q = this.node.getWorldRotation();
                    Vector3f dir = dl.getDirection();
                    q.multLocal(dir);
                    dl.setDirection(dir);
                } else if (this.light instanceof PointLight) {
                    PointLight pl = (PointLight)this.light;
                    Vector3f pos = this.node.getWorldTranslation();
                    pl.setPosition(pos);
                } else if (this.light instanceof SpotLight) {
                    SpotLight sl = (SpotLight)this.light;
                    Vector3f pos = this.node.getWorldTranslation();
                    sl.setPosition(pos);
                    Quaternion q = this.node.getWorldRotation();
                    Vector3f dir = sl.getDirection();
                    q.multLocal(dir);
                    sl.setDirection(dir);
                }
            }
            this.light = null;
        }
        this.checkTopNode(qName);
        this.elementStack.pop();
    }

    public void characters(char[] ch, int start, int length) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        try {
            this.key = info.getKey();
            this.assetManager = info.getManager();
            this.sceneName = this.key.getName();
            String ext = this.key.getExtension();
            this.folderName = this.key.getFolder();
            this.sceneName = this.sceneName.substring(0, this.sceneName.length() - ext.length() - 1);
            this.reset();
            this.materialList = this.materialLoader.load(this.assetManager, this.folderName, info.openStream());
            if (this.materialList == null || this.materialList.isEmpty()) {
                OgreMaterialKey materialKey = new OgreMaterialKey(this.sceneName + ".material");
                try {
                    this.materialList = this.assetManager.loadAsset(materialKey);
                }
                catch (AssetNotFoundException ex) {
                    logger.log(Level.WARNING, "Cannot locate {0} for scene {1}", new Object[]{materialKey, this.key});
                    this.materialList = null;
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = null;
            try {
                r = new InputStreamReader(info.openStream());
                xr.parse(new InputSource(r));
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return this.root;
        }
        catch (SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
        catch (ParserConfigurationException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

