/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.bounding.BoundingBox;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import java.util.Set;
import jme3tools.optimize.Octnode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastOctnode {
    int offset;
    int length;
    FastOctnode child;
    FastOctnode next;
    private static final BoundingBox tempBox = new BoundingBox();

    public int getSide() {
        return (this.offset & 0xE0000000) >> 29 & 7;
    }

    public void setSide(int side) {
        this.offset &= 0x1FFFFFFF;
        this.offset |= side << 29;
    }

    public void setOffset(int offset) {
        if (offset < 0 || offset > 20000000) {
            throw new IllegalArgumentException();
        }
        this.offset &= 0xE0000000;
        this.offset |= offset;
    }

    public int getOffset() {
        return this.offset & 0x1FFFFFFF;
    }

    private void generateRenderSetNoCheck(Geometry[] globalGeomList, Set<Geometry> renderSet, Camera cam) {
        if (this.length != 0) {
            int start = this.getOffset();
            int end = start + this.length;
            for (int i = start; i < end; ++i) {
                renderSet.add(globalGeomList[i]);
            }
        }
        if (this.child == null) {
            return;
        }
        FastOctnode node = this.child;
        while (node != null) {
            node.generateRenderSetNoCheck(globalGeomList, renderSet, cam);
            node = node.next;
        }
    }

    private static void findChildBound(BoundingBox bbox, int side) {
        float extent = bbox.getXExtent() * 0.5f;
        bbox.getCenter().set(bbox.getCenter().x + extent * Octnode.extentMult[side].x, bbox.getCenter().y + extent * Octnode.extentMult[side].y, bbox.getCenter().z + extent * Octnode.extentMult[side].z);
        bbox.setXExtent(extent);
        bbox.setYExtent(extent);
        bbox.setZExtent(extent);
    }

    public void generateRenderSet(Geometry[] globalGeomList, Set<Geometry> renderSet, Camera cam, BoundingBox parentBox, boolean isRoot) {
        tempBox.setCenter(parentBox.getCenter());
        tempBox.setXExtent(parentBox.getXExtent());
        tempBox.setYExtent(parentBox.getYExtent());
        tempBox.setZExtent(parentBox.getZExtent());
        if (!isRoot) {
            FastOctnode.findChildBound(tempBox, this.getSide());
        }
        tempBox.setCheckPlane(0);
        cam.setPlaneState(0);
        Camera.FrustumIntersect result = cam.contains(tempBox);
        if (result != Camera.FrustumIntersect.Outside) {
            if (this.length != 0) {
                int start = this.getOffset();
                int end = start + this.length;
                for (int i = start; i < end; ++i) {
                    renderSet.add(globalGeomList[i]);
                }
            }
            if (this.child == null) {
                return;
            }
            FastOctnode node = this.child;
            float x = FastOctnode.tempBox.getCenter().x;
            float y = FastOctnode.tempBox.getCenter().y;
            float z = FastOctnode.tempBox.getCenter().z;
            float ext = tempBox.getXExtent();
            while (node != null) {
                if (result == Camera.FrustumIntersect.Inside) {
                    node.generateRenderSetNoCheck(globalGeomList, renderSet, cam);
                } else {
                    node.generateRenderSet(globalGeomList, renderSet, cam, tempBox, false);
                }
                tempBox.getCenter().set(x, y, z);
                tempBox.setXExtent(ext);
                tempBox.setYExtent(ext);
                tempBox.setZExtent(ext);
                node = node.next;
            }
        }
    }

    public String toString() {
        return "OCTNode[O=" + this.getOffset() + ", L=" + this.length + ", S=" + this.getSide() + "]";
    }

    public String toStringVerbose(int indent) {
        String str = "------------------".substring(0, indent) + this.toString() + "\n";
        if (this.child == null) {
            return str;
        }
        FastOctnode children = this.child;
        while (children != null) {
            str = str + children.toStringVerbose(indent + 1);
            children = children.next;
        }
        return str;
    }
}

