/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.app.SimpleApplication;
import com.jme3.bounding.BoundingBox;
import com.jme3.light.DirectionalLight;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.plugins.ogre.MeshLoader;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.texture.FrameBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import jme3tools.optimize.FastOctnode;
import jme3tools.optimize.Octree;

public class TestOctree
extends SimpleApplication
implements SceneProcessor {
    private Octree tree;
    private FastOctnode fastRoot;
    private Geometry[] globalGeoms;
    private BoundingBox octBox;
    private Set<Geometry> renderSet = new HashSet<Geometry>(300);
    private Material mat;
    private Material mat2;
    private WireBox box = new WireBox(1.0f, 1.0f, 1.0f);

    public static void main(String[] args) {
        TestOctree app = new TestOctree();
        app.start();
    }

    public void simpleInitApp() {
        MeshLoader.AUTO_INTERLEAVE = false;
        this.assetManager.registerLocator("quake3level.zip", "com.jme3.asset.plugins.ZipLocator");
        MaterialList matList = (MaterialList)this.assetManager.loadAsset("Scene.material");
        OgreMeshKey key = new OgreMeshKey("main.meshxml", matList);
        Spatial scene = this.assetManager.loadModel(key);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalize());
        this.rootNode.addLight(dl);
        DirectionalLight dl2 = new DirectionalLight();
        dl2.setColor(ColorRGBA.White);
        dl2.setDirection(new Vector3f(1.0f, -1.0f, 1.0f).normalize());
        this.rootNode.addLight(dl2);
        this.tree = new Octree(scene, 50);
        this.tree.construct();
        ArrayList<Geometry> globalGeomList = new ArrayList<Geometry>();
        this.tree.createFastOctnodes(globalGeomList);
        this.tree.generateFastOctnodeLinks();
        for (Geometry geom : globalGeomList) {
            geom.addLight(dl);
            geom.addLight(dl2);
            geom.updateGeometricState();
        }
        this.globalGeoms = globalGeomList.toArray(new Geometry[0]);
        this.fastRoot = this.tree.getFastRoot();
        this.octBox = this.tree.getBound();
        this.viewPort.addProcessor(this);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return true;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
        this.renderSet.clear();
        this.fastRoot.generateRenderSet(this.globalGeoms, this.renderSet, this.cam, this.octBox, true);
        int tris = 0;
        for (Geometry geom : this.renderSet) {
            tris += geom.getTriangleCount();
            rq.addToQueue(geom, geom.getQueueBucket());
        }
    }

    public void postFrame(FrameBuffer out) {
    }

    public void cleanup() {
    }
}

