/**
 * POSTリクエスト受信サンプルです。
 * 受信したPOSTリクエストをエコーバックします。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"

#include "NyLPC_http.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"

const struct NyLPC_TiNetInterface_Interface* netif;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

typedef struct TcModFileIoDumy
{
	NyLPC_TcModFileIoBaseClass_t super;
}TcFileIoDumy_t;


NyLPC_TBool upload(NyLPC_TcHttpdConnection_t* i_connection,const NyLPC_TChar* i_fname,NyLPC_TcHttpBodyParser_t* i_body_parser)
{
	char buf[64];
	NyLPC_TInt16 l;
	if(!NyLPC_cHttpBodyParser_parseStream(i_body_parser,NyLPC_cHttpdConnection_refStream(i_connection),buf,64,&l)){
		return -1;
	}
	while(l>0){
//		NyLPC_cHttpdConnection_sendResponseBody(i_connection,url,l);
		if(!NyLPC_cHttpBodyParser_parseStream(i_body_parser,NyLPC_cHttpdConnection_refStream(i_connection),buf,64,&l)){
			return -1;
		}
	}

	return NyLPC_TBool_TRUE;
}

NyLPC_TBool create(NyLPC_TcHttpdConnection_t* i_connection,const NyLPC_TChar* i_fname)
{
	return NyLPC_TBool_TRUE;
}

/**
 * i_fnameのファイルを削除します。
 * この関数はHTTPD_LOCKがかかった状態でコールされます。
 * @return
 * 処理が失敗した場合はFALSEを返します。FALSEを返すとCallerはHTTPセッションを切断します。
 */
NyLPC_TBool remove(NyLPC_TcHttpdConnection_t* i_connection,const NyLPC_TChar* i_fname)
{
	return NyLPC_TBool_TRUE;
}



void cModFileIoDumy_initialize(TcFileIoDumy_t* i_inst)
{
	NyLPC_cModFileIoBaseClass_initialize(&(i_inst->super),"test");
	i_inst->super._abstruct_function.upload=upload;
	i_inst->super._abstruct_function.create=create;
	i_inst->super._abstruct_function.remove=remove;
}
#define cModFileIoDumy_finalize(i_inst) NyLPC_cModFileIoBaseClass_finalize(&(i_inst)->super)
#define cModFileIoDumy_canHandle(i_inst,i_connection) NyLPC_cModFileIoBaseClass_canHandle(&(i_inst)->super,i_connection)
#define cModFileIoDumy_execute(i_inst,i_connection) NyLPC_cModFileIoBaseClass_execute(&(i_inst)->super,i_connection)




void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	TcFileIoDumy_t mod;
	//SHORT URL
	cModFileIoDumy_initialize(&mod);
	if(!cModFileIoDumy_canHandle(&mod,i_connection)){
		cModFileIoDumy_finalize(&mod);
		return;
	}
	if(!cModFileIoDumy_execute(&mod,i_connection)){
		cModFileIoDumy_finalize(&mod);
		return;
	}
	cModFileIoDumy_finalize(&mod);
	return;
}
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);

	NyLPC_cHttpd_initialize(&httpd.super,80);
	httpd.super.function.onRequest=handler;

}


void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	//192.168.0.39
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&net,&c2);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}


