/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *
 * Parts of this file were leveraged from uIP:
 *
 * Copyright (c) 2001-2003, Adam Dunkels.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "NyLPC_uip.h"
/* Header sizes. */
#if UIP_CONF_IPV6
#define UIP_IPH_LEN    40
#else /* UIP_CONF_IPV6 */
#define UIP_IPH_LEN    20    /* Size of IP header */
#endif /* UIP_CONF_IPV6 */
#define UIP_UDPH_LEN    8    /* Size of UDP header */
#define UIP_TCPH_LEN   20    /* Size of TCP header */
#define UIP_IPUDPH_LEN (UIP_UDPH_LEN + UIP_IPH_LEN)    /* Size of IP +
							  UDP
							  header */
#define UIP_IPTCPH_LEN (UIP_TCPH_LEN + UIP_IPH_LEN)    /* Size of IP +
							  TCP
							  header */
#define UIP_TCPIP_HLEN UIP_IPTCPH_LEN


#if !UIP_CONF_IPV6

#else /* !UIP_CONF_IPV6 */
#define uip_ipaddr_copy(dest, src) memcpy(dest, src, sizeof(uip_ip6addr_t))
#endif /* !UIP_CONF_IPV6 */

#define uip_ip6addr(addr, addr0,addr1,addr2,addr3,addr4,addr5,addr6,addr7) do { \
                     ((u16_t *)(addr))[0] = NyLPC_HTONS((addr0)); \
                     ((u16_t *)(addr))[1] = NyLPC_HTONS((addr1)); \
                     ((u16_t *)(addr))[2] = NyLPC_HTONS((addr2)); \
                     ((u16_t *)(addr))[3] = NyLPC_HTONS((addr3)); \
                     ((u16_t *)(addr))[4] = NyLPC_HTONS((addr4)); \
                     ((u16_t *)(addr))[5] = NyLPC_HTONS((addr5)); \
                     ((u16_t *)(addr))[6] = NyLPC_HTONS((addr6)); \
                     ((u16_t *)(addr))[7] = NyLPC_HTONS((addr7)); \
                  } while(0)

/*---------------------------------------------------------------------------*/
#if UIP_CONF_IPV6
NyLPC_TUInt16
uip_icmp6chksum(void)
{
	return upper_layer_chksum(UIP_PROTO_ICMP6);

}

/*---------------------------------------------------------------------------*/

/**
 * チェックサムは、TCP疑似ヘッダから計算。
 * 送信元IPアドレス+あて先/もどりIPアドレス+ProtocolID+パケット長
 */
static NyLPC_TUInt16 upper_layer_chksum(NyLPC_TUInt8 proto,NyLPC_TUInt16 i_len_of_data)
{
	NyLPC_TUInt16 sum;

#if UIP_CONF_IPV6
	i_len_of_data = i_len_of_data;
#else /* UIP_CONF_IPV6 */
	i_len_of_data = i_len_of_data- UIP_IPH_LEN;
#endif /* UIP_CONF_IPV6 */

	/* First sum pseudoheader. */

	/* IP protocol and length fields. This addition cannot carry. */
	sum = i_len_of_data + proto;
	/* Sum IP source and destination addresses. */
//	sum = chksum(sum, (u8_t *) &(BUF->srcipaddr), 2 * sizeof(uip_ipaddr_t));

	/* Sum TCP header and data. */
//	sum = chksum(sum, &uip_buf[UIP_IPH_LEN + UIP_LLH_LEN], i_len_of_data);

	return (sum == 0) ? 0xffff : NyLPC_htons(sum);
}


void uip_process_ip6(const struct NyLPC_TIPv4Payload* i_rx,NyLPC_TUInt16 i_payload_size)
{/*
	u16_t tmp;

	//IPパケットのバージョンチェック
	if((i_rx->header->vhl & 0xf0)!=0x60){
		return;//drop;
	}
	if(NyLPC_ntohs(i_rx->->len16) <= uip_len){
		uip_len += 40;
		/* The length reported in the IPv6 header is the
		 length of the payload that follows the
		 header. However, uIP uses the uip_len variable
		 for holding the size of the entire packet,
		 including the IP header. For IPv4 this is not a
		 problem as the length field in the IPv4 header
		 contains the length of the entire packet. But
		 for IPv6 we need to add the size of the IPv6
		 header (40 bytes). *//*
	}else{
		return;//drop;
	}
	switch(in.v6.header->proto)
	{
	case UIP_PROTO_TCP:
	case UIP_PROTO_UDP:
		//	//uip_process_UDP();//実装したら解除いして
		return;
	case UIP_PROTO_ICMP6:
	//			uip_process_ICMP6(&in_packet,&out_packet);
		return;
	}
	break;//drop*/
}
void uip_tcp_v6(void)
{
	/* For IPv6, packet reception is a little trickier as we need to
	 make sure that we listen to certain multicast addresses (all
	 hosts multicast address, and the solicited-node multicast
	 address) as well. However, we will cheat here and accept all
	 multicast packets that are sent to the ff02::/16 addresses. */
/*	if(!uip_ipaddr_cmp(BUF->destipaddr, uip_hostaddr) &&
			BUF->destipaddr[0] != NyLPC_HTONS(0xff02)) {
		UIP_STAT(++uip_stat.header.drop);
		goto drop;
	}*/
}
#endif /* UIP_CONF_IPV6 */
