/**
 * LPCXPresso1769用の高レベルMiMicAPI
 MiMicCoreの関数を必要とします。
 */
var LPCXpresso1769;

(function(){
	var isUndef=MiMicLib.isUndef;
	
	var DEV=
	{
		/**
		 * エラーIDテーブルの拡張
		 */
		_EE:function(i_base){
		return{
			NG:[i_base|0x00,"Unknown exception in LPCXpresso1769"],
			INVALID_ARG :[i_base|0x01,"Invalid argument"],
			INVALID_PIN :[i_base|0x02,"Invalid pin"],
			INVALID_CFG :[i_base|0x03,"Invalid configulation"],
			VM_RUNTIME  :[i_base|0x04,"MVM runtime error"],
		};}(MiMicError.NG[0]|MiMicError.MID_MiMic|MiMicError.CAID_LPCXPresso1769),
		/**
		 * BCフラグメント・ライブラリ
		 */
		_BCF:{
			/**
			 * ([i_addr]&(~(i_mask<<i_shl))|((i_mask & i_val)<<i_shl)を実行するMimicBCを生成する。
			 [S0]のアドレスのメモリ値に[S1]の値でマスクして,[S2]の値とORして[S0]に書き戻す。
			 SGET #0;
			 SGET #1;
			 SGET #2;
			 MGET #7,#0;
			 AND #7,#1;
			 OR #7,#2;
			 MPUT #7,#0;
			 @param i_mask
			 ビットマスク
			 @param i_val
			 ビット値
			 */
			setBit:function setBit(i_addr,i_mask,i_val,i_shl,i_db)
			{
				try{
					i_db.push(i_addr);
					i_db.push(~(i_mask<<i_shl));
					i_db.push((i_mask & i_val) << i_shl);
					return "EA00EA01EA02DB0700AA0701AE0702DF0700";
				}catch(e){
					throw new MiMicException(e);
				}			
			},
			/**
			 * 値をメモリに設定する。
			 	SGET #0
			 	SGET #1
			 	MPUT #1,#0
			 */
			setMem:function setMem(i_addr,i_val,i_db)
			{
				try{
					i_db.push(i_addr);
					i_db.push(i_val);
					return "EA00EA01DF0100";
				}catch(e){
					throw new MiMicException(e);
				}			
			},
			/*	メモリを32bit読む
			 	SGET #0
			 	MGET #0,#0
			 	SPUT #0
			 */			
			getMem:function getMem(i_addr,i_db)
			{
				try{
					i_db.push(i_addr);
					return "EA00DB0000EE00";
				}catch(e){
					throw new MiMicException(e);
				}			
			},
			/*	メモリを32bit読む
			 	SGET #0
			 	MGET #0,#0
			 	SPUT #0
			 */
			READMEM:"EA00DB0000EE00",
			
			/**
			 * BCフラグメントを終了する。
				 EXIT;
				 .END
			 */
			END:"ZZ.E"	
		},
		/**
		 * @see API manual
		 */
		FUNC_NAME:[
			"GPIO","AD","DA"
		],
		/**
		 * @see API manual
		 */
		PHY_NAME:[
			"GPIO","ADC","DAC"
		],
		/**
		 * @see API manual
		 PHY:{PHY_NAME:[PCLKSELreg#PCLKSELbit,PCONPbit]}
		 */
		PHY:{
			WDT:	[0,0,null],
			TIMER0:	[0,2,1],
			TIMER1:	[0,4,2],
			UART0:	[0,6,3],
			UART1:	[0,8,4],
			PWM1:	[0,12,6],
			I2C0:	[0,14,7],
			SPI:	[0,16,8],
			RTC:	[null,null,9],
			SSPI1:	[0,20,10],
			DAC:	[0,22,null],
			ADC:	[0,24,12],
			CAN1:	[0,26,13],
			CAN2:	[0,28,14],
			ACF:	[0,30,null],
			QEI:	[1,0,18],
			GPIOINT:[1,2,15],
			PCB:	[1,4,null],
			I2C1:	[1,6,19],
			SSP0:	[1,10,21],
			TIMER2:	[1,12,22],
			TIMER3:	[1,14,23],
			UART2:	[1,16,24],
			UART3:	[1,18,25],
			I2C2:	[1,20,26],
			I2S:	[1,22,27],
			RIT:	[1,26,16],
			SYSCON:	[1,28,null],
			PWM_MC:[1,30,17],//MC?
			GPDMA:[null,null,29],
			ENET:[null,null,30],
			USB:[null,null,31]
		},
		/**
		 * @see API Manual
		 */
		P0:[
			[0,0,0,0,["GPIO0.0","RD1","TXD3","SDA1"]],//0
			[0,0,0,1,["GPIO0.1","TD1","RXD3","SCL1"]],//1
			[0,0,0,2,["GPIO0.2","TXD0","AD0.7",null]],//2
			[0,0,0,3,["GPIO0.3","RXD0","AD0.6",null]],//3
			[0,0,0,4,["GPIO0.4","I2SRX_CLK","RD2","CAP2.0"]],//4
			[0,0,0,5,["GPIO0.5","I2SRX_WS","TD2","CAP2.1"]],//5
			[0,0,0,6,["GPIO0.6","I2SRX_SDA","SSEL1","MAT2.0"]],//6
			[0,0,0,7,["GPIO0.7","I2STX_CLK","SCK1",	"MAT2.1"]],//7
			[0,0,0,8,["GPIO0.8","I2STX_WS","MISO1","MAT2.2"]],//8
			[0,0,0,9,["GPIO0.9","I2STX_SDA","MOSI1","MAT2.3"]],//9
			[0,0,0,10,["GPIO0.10","TXD2","SDA2","MAT3.0"]],//10
			[0,0,0,11,["GPIO0.11","RXD2","SCL2","MAT3.1"]],//11
			null,null,null,//12,13,14
			[0,0,0,15,["GPIO0.15","TXD1","SCK0","SCK"]],//15
			[1,1,0,16,["GPIO0.16","RXD1","SSEL0","SSEL"]],//16
			[1,1,0,17,["GPIO0.17","CTS1","MISO0","MISO"]],//17
			[1,1,0,18,["GPIO0.18","DCD1","MOSI0","MOSI"]],//18
			[1,1,0,19,["GPIO0.19","DSR1",null,"SDA1"]],//19
			[1,1,0,20,["GPIO0.20","DTR1",null,"SCL1"]],//20
			[1,1,0,21,["GPIO0.21","RI1",null,"RD1"]],//21
			[1,1,0,22,["GPIO0.22","RTS1",null,"TD1"]],//22
			[1,1,0,23,["GPIO0.23","AD0.0","I2SRX_CLK","CAP3.0"]],//23
			[1,1,0,24,["GPIO0.24","AD0.1","I2SRX_WS","CAP3.1"]],//24
			[1,1,0,25,["GPIO0.25","AD0.2","I2SRX_SDA","TXD3"]],//25
			[1,1,0,26,["GPIO0.26","AD0.3","AOUT","RXD3"]],//26
			[1,null,null,22,["GPIO0.27","SDA0",	"USB_SDA",null]],//27
			[1,null,null,24,["GPIO0.28","SCL0",	"USB_SCL",null]],//28
			[1,null,0,29,["GPIO0.29","USB_D+",null,null]],//29
			[1,null,0,30,["GPIO0.30","USB_D-",null,null]],//30
			],
		P1:[	//P1[x]
			[2,2,1,0,["GPIO1.0","ENET_TXD0",null,null]],//0
			[2,2,1,1,["GPIO1.1","ENET_TXD1",null,null]],//1
			null,null,//2,3
			[2,2,1,4,["GPIO1.4","ENET_TX_EN",null,null]],//4
			null,null,null,//5,6,7
			[2,2,1,8,["GPIO1.8","ENET_CRS",null,null]],//8
			[2,2,1,9,["GPIO1.9","ENET_RXD0",null,null]],//9
			[2,2,1,10,["GPIO1.10","ENET_RXD1",null,null]],//10
			null,null,null,//11,12,13
			[2,2,1,14,["GPIO1.14","ENET_RX_ER",null,null]],//14
			[2,2,1,15,["GPIO1.15","ENET_REF_CLK",null,null]],//15
			[3,3,1,16,["GPIO1.16","ENET_MDC",null,null]],//16
			[3,3,1,17,["GPIO1.17","ENET_MDIO",null,null]],//17
			[3,3,1,18,["GPIO1.18","USB_UP_LED","PWM1.1","CAP1.0"]],//18
			[3,3,1,19,["GPIO1.19","MCOA0","USB_PPWR","CAP1.1"]],//19
			[3,3,1,20,["GPIO1.20","MCI0","PWM1.2","SCK0"]],//20
			[3,3,1,21,["GPIO1.21","MCABORT","PWM1.3","SSEL0"]],//21
			[3,3,1,22,["GPIO1.22","MCOB0","USB_PWRD","MAT1.0"]],//22
			[3,3,1,23,["GPIO1.23","MCI1","PWM1.4","MISO0"]],//23
			[3,3,1,24,["GPIO1.24","MCI2","PWM1.5","MOSI0"]],//24
			[3,3,1,25,["GPIO1.25","MCOA1",null,"MAT1.1"]],//25
			[3,3,1,26,["GPIO1.26","MCOB1","PWM1.6","CAP0.0"]],//26
			[3,3,1,27,["GPIO1.27","CLKOUT","USB_OVRCR","CAP0.1"]],//27
			[3,3,1,28,["GPIO1.28","MCOA2","PCAP1.0","MAT0.0"]],//28
			[3,3,1,29,["GPIO1.29","MCOB2","PCAP1.1","MAT0.1"]],//29
			[3,3,1,30,["GPIO1.30",null,"VBUS","AD0.4"]],//30
			[3,3,1,31,["GPIO1.31",null,"SCK1","AD0.5"]],//31
			],
		P2:[	//P2[x]
			[4,4,2,0,["GPIO2.0","PWM1.1","TXD1",null]],//0
			[4,4,2,1,["GPIO2.1","PWM1.2","RXD1",null]],//1
			[4,4,2,2,["GPIO2.2","PWM1.3","CTS1",null]],//2
			[4,4,2,3,["GPIO2.3","PWM1.4","DCD1",null]],//3
			[4,4,2,4,["GPIO2.4","PWM1.5","DSR1",null]],//4
			[4,4,2,5,["GPIO2.5","PWM1.6","DTR1",null]],//5
			[4,4,2,6,["GPIO2.6","PCAP1.0","RI1",null]],//6
			[4,4,2,7,["GPIO2.7","RD2","RTS1",null]],//7
			[4,4,2,8,["GPIO2.8","TD2","TXD2","ENET_MDC"]],//8
			[4,4,2,9,["GPIO2.9","USB_CONNECT","RXD2","ENET_MDIO"]],//9
			[4,4,2,10,["GPIO2.10","EINT0","NMI",null]],//10
			[4,4,2,11,["GPIO2.11","EINT1",null,"I2STX_CLK"]],//11
			[4,4,2,12,["GPIO2.12","EINT2",null,"I2STX_WS"]],//12
			[4,4,2,13,["GPIO2.13","EINT3",null,"I2STX_SDA"]],//13
			],
		P3:[	//P3[x]
			null/* 0*/,null/* 1*/,null/* 2*/,null/* 3*/,null/* 4*/,null/* 5*/,null/* 6*/,null/* 7*/,null/* 8*/,null/* 9*/,
			null/*10*/,null/*11*/,null/*12*/,null/*13*/,null/*14*/,null/*15*/,null/*16*/,null/*17*/,null/*18*/,null/*19*/,
			null/*20*/,null/*21*/,null/*22*/,null/*23*/,null/*24*/,
			[7,7,3,25,["GPIO3.25",null,"MAT0.0","PWM1.2"]],//25
			[7,7,3,26,["GPIO3.26","STCLK","MAT0.1","PWM1.3"]],//26
		],
		P4:[	//P4[x]
			null/* 0*/,null/* 1*/,null/* 2*/,null/* 3*/,null/* 4*/,null/* 5*/,null/* 6*/,null/* 7*/,null/* 8*/,null/* 9*/,
			null/*10*/,null/*11*/,null/*12*/,null/*13*/,null/*14*/,null/*15*/,null/*16*/,null/*17*/,null/*18*/,null/*19*/,
			null/*20*/,null/*21*/,null/*22*/,null/*23*/,null/*24*/,null/*25*/,null/*26*/,null/*27*/,
			[9,9,4,28,["GPIO4.28","RX_MCLK","MAT2.0","TXD3"]],//28
			[9,9,4,29,["GPIO4.29","TX_MCLK","MAT2.1","RXD3"]]//29
		],
		/**
		 * [forSystem]ピン識別子のアクセス関数である。
		ピン機能シンボルのプレフィクス（機能シンボル）を、 ピン識別子を元に、完全な名称に変換する。
		 ピンにFunctionが含まれているか調べることが出来る。
		 */
		completePinFunctionName:function completePinFunctionName(i_pin,i_prefix)
		{
			try{
				//配列探索
				for(var i=0;i<i_pin[4].length;i++){
					if(i_pin[4][i].indexOf(i_prefix)==0){
						//ピン情報の構成
						return i_pin[4][i];
					}
				}
				throw new MiMicException("The function name '"+i_prefix+"' is not unknown.");
			}catch(e){
				throw new MiMicException(e);
			}
		},
		/**
		 * [forSystem]ピン識別子のアクセス関数。
		 ピン識別値から、Pinレジスタの番号と、ビット位置を取り出す。
		 @return
		 {s:pinselのレジスタ番号、m:modeのレジスタ番号、,o:odのレジスタ番号,sbm:mode,selのビット位置,ob:odのビット位置}
		 */
		getPinRegInfo:function getPinRegInfo(i_pin)
		{
			try{
				return {s:i_pin[0],m:i_pin[1],o:i_pin[2],smb:(i_pin[3]%16)*2,ob:i_pin[3]};
			}catch(e){
				throw new MiMicException(e);
			}
		},
		/**
		 * [forSystem]ピン識別子のアクセス関数。
		 PIN機能名に一致するPinsel値を取り出す。
		 */
		getPinSelByFunctionName:function getPinSelByFunctionName(i_pin,i_name)
		{
			try{
				for(var i=0;i<i_pin[4].length;i++){
					if(i_pin[4][i]==i_name){
						//ピン情報の構成
						return i;
					}
				}
				throw new MiMicException("The function name '"+i_name+"' has not function.");
			}catch(e){
				throw new MiMicException(e);
			}
		},
		/**
		 * [forSystem]ピンが、ピン機能シンボルを持つか返す。
		 */
		hasPinFunctionName:function hasPinFunctionName(i_pin,i_name)
		{
			return i_pin[4].indexOf(i_name)>=0;
		}
	}


DEV.I2c=function I2c()
{
	throw new MiMicException("Not imprement.");
}
DEV.Pwm=function Pwm()
{
	throw new MiMicException("Not imprement.");
}
DEV.Dma=function Dma()
{
	throw new MiMicException("Not imprement.");
}
DEV.Uart=function Uart()
{
	throw new MiMicException("Not imprement.");
}
DEV.Usb=function Usb()
{
	throw new MiMicException("Not imprement.");
}


LPCXpresso1769=DEV;
}());

