/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_cSyncProc.h"
#include "NyLPC_cSyncCall.h"
/**
 * コンストラクタです。
 */
NyLPC_TBool NyLPC_cSyncProc_initialize(NyLPC_TcSyncProc_t* i_inst)
{
	i_inst->_q=xQueueCreate(1,sizeof(void*));
	NyLPC_Assert(i_inst->_q!=NULL);
	i_inst->_last_caller=NULL;
	return NyLPC_TBool_TRUE;
}

NyLPC_TBool NyLPC_cSyncProc_waitCall(NyLPC_TcSyncProc_t* i_inst,void** o_msg,NyLPC_TUInt32 i_wait_msec)
{
	void** param;//[0]=caller,[1]=msg
	NyLPC_ArgAssert(i_inst!=NULL);
	if(xQueueReceive(i_inst->_q,&param,i_wait_msec/portTICK_RATE_MS)==pdPASS){
		i_inst->_last_caller=((NyLPC_TcSyncCall_t*)(*param));
		*o_msg=*(param+1);
		return NyLPC_TBool_TRUE;
	}
	return NyLPC_TBool_FALSE;
}
/**
 * NyLPC_cSyncCall_callのブロックを解除します。
 */
void NyLPC_cSyncProc_returnCall(NyLPC_TcSyncProc_t* i_inst)
{
	NyLPC_ArgAssert(i_inst!=NULL);
	NyLPC_Assert(i_inst->_last_caller);
	NyLPC_AbortIfNot(pdPASS==xQueueSend(i_inst->_last_caller->_q,NULL,portMAX_DELAY));
	i_inst->_last_caller=NULL;
}
