/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NyLPC_TcFifoBuffer_H
#define NyLPC_TcFifoBuffer_H

typedef struct NyLPC_TcFifoBuffer NyLPC_TcFifoBuffer_t;

#include "NyLPC_stdlib.h"

struct NyLPC_TcFifoBuffer
{
	/** 配列の最大サイズ*/
	NyLPC_TUInt16 size;
	/** 配列の現在の長さ*/
	NyLPC_TUInt16 len;
	/** バッファ領域*/
	void* buf;
};

/**
 * i_instを、i_bufをラップするインスタンスとして初期化します。
 * i_bufは参照されます。インスタンスを削除するまでの間、維持してください。
 */
void NyLPC_cFifoBuffer_initialize(NyLPC_TcFifoBuffer_t* i_inst,void* i_buf,NyLPC_TUInt16 i_buf_size);

#define NyLPC_cFifoBuffer_finalize(i_inst)

/**
 * バッファの内容をクリアします。
 */
#define NyLPC_cFifoBuffer_clear(i_inst) (i_inst)->len=0;

/**
 * バッファの後方にデータを格納します。
 * 十分なサイズがない場合、ASSERTします。
 */
void NyLPC_cFifoBuffer_push(NyLPC_TcFifoBuffer_t* i_inst,const void* i_data,NyLPC_TUInt16 i_data_len);

/**
 * バッファの先頭からデータを取り出します。
 * 十分なデータがない場合、ASSERTします。
 */
void NyLPC_cFifoBuffer_pop(NyLPC_TcFifoBuffer_t* i_inst,NyLPC_TUInt16 i_len);

/**
 * バッファの先頭ポインタを得ます。
 */
void* NyLPC_cFifoBuffer_getPtr(const NyLPC_TcFifoBuffer_t* i_inst);

/**
 * 格納しているデータの長さを返します。
 */
NyLPC_TUInt16 NyLPC_cFifoBuffer_getLength(const NyLPC_TcFifoBuffer_t* i_inst);

/**
 * バッファの残量を計算して返します。
 */
NyLPC_TUInt16 NyLPC_cFifoBuffer_getSpace(const NyLPC_TcFifoBuffer_t* i_inst);

#endif
