/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_stdlib.h"
NyLPC_TUInt32 NyLPC_TUInt32_bswap(NyLPC_TUInt32 n)
{
	return(
		((((NyLPC_TUInt32)(n))<<24)&0xff000000)|
		((((NyLPC_TUInt32)(n))<< 8)&0x00ff0000)|
		((((NyLPC_TUInt32)(n))>> 8)&0x0000ff00)|
		((((NyLPC_TUInt32)(n))>>24)&0x000000ff));
}
NyLPC_TUInt16 NyLPC_TUInt16_bswap(NyLPC_TUInt16 n)
{
	return NyLPC_TUInt16_BSWAP(n);
}

static int _line_log_l;
static const char* _line_log_m;
unsigned int NyLPC_assert_counter=0;
unsigned int NyLPC_abort_counter=0;
unsigned int NyLPC_debug_counter=0;

void NyLPC_assertHook(const char* m,int l)
{
	_line_log_l=l;
	_line_log_m=m;
	NyLPC_assert_counter++;
	return;
}
void NyLPC_abortHook(const char* m,int l)
{
	_line_log_l=l;
	_line_log_m=m;
	NyLPC_abort_counter++;
}
void NyLPC_debugHook(const char* m,int l)
{
	_line_log_l=l;
	_line_log_m=m;
	NyLPC_debug_counter++;
	return;
}

