/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_CSDSERCICE_H_
#define NYLPC_CSDSERCICE_H_


//Free RTOS
#include "FreeRTOS.h"
#include "semphr.h"

//driver
#include "../driver/fatfs/ff.h"
//NyLPC
#include "NyLPC_stdlib.h"



typedef struct NyLPC_TcSdService NyLPC_TcSdService_t;
typedef struct NyLPC_TcSdFile NyLPC_TcSdFile_t;

/**
 * sdServiceを開始します。
 */
#define NyLPC_sdService_start() NyLPC_cSdService_initialize()

/**********************************************************************
 *
 * NyLPC_TcSdService class
 * このクラスは、SDファイルシステムに関するサービスを提供します。
 * システムの中に1個だけ生成する事ができます。
 *
 **********************************************************************/

/**
 * 唯一のSDファイルシステムクラス
 */
struct NyLPC_TcSdService
{
	xSemaphoreHandle mutex;
	FATFS _fs_object;
	/** fatfsの返却した最後のエラー値*/
	FRESULT _last_err;
	/** FSをロックしているオブジェクト*/
	void* _locked_object;
};


NyLPC_TBool NyLPC_cSdService_initialize();

/**********************************************************************
 *
 * NyLPC_TcSdFile class
 *
 * このクラスは、ファイルアクセスAPIを提供します。
 * NyLPC_TcSdServiceサービスを初期化後に使用可能になります。
 *
 **********************************************************************/

struct NyLPC_TcSdFile
{
	/** fatfsのポインタ*/
	FIL _fsfp;
};

/**
 * インスタンスを生成します。
 */
NyLPC_TBool NyLPC_cSdFile_initialize(const NyLPC_TChar* i_fname,BYTE i_ff_mode,NyLPC_TcSdFile_t* o_inst);


/**
 * インスタンスを破棄します。占有している資源があれば、同時に開放します。
 */
void NyLPC_cSdFile_finalize(NyLPC_TcSdFile_t* i_inst);

/**
 * 最大i_buf_lenのデータをファイルから読みだす。
 * エラーが発生した時は、速やかにオブジェクトをクローズして破棄する事。
 */
NyLPC_TBool NyLPC_cSdFile_read(NyLPC_TcSdFile_t* i_inst,void* o_buf,NyLPC_TInt32 i_buf_len,NyLPC_TInt32* o_dest_len);

/**
 * 最大i_buf_lenのデータをファイルから読みだす。
 * エラーが発生した時は、速やかにオブジェクトをクローズして破棄する事。
 */
NyLPC_TBool NyLPC_cSdFile_write(NyLPC_TcSdFile_t* i_inst,void* i_buf,NyLPC_TInt32 i_buf_len);

/**
 * ファイルオブジェクトをクローズします。
 */
NyLPC_TBool NyLPC_cSdFile_close(NyLPC_TcSdFile_t* i_inst);
/**
 * FatFSのFilオブジェクトを、FSを占有した状態で返します。
 */
NyLPC_TBool NyLPC_cSdFile_getFIL(NyLPC_TcSdFile_t* i_inst,FIL** o_fil);

/**
 * NyLPC_cSdFile_getFILで取得したロック済みFilオブジェクトを開放します。
 */
void NyLPC_cSdFile_releaseFIL(NyLPC_TcSdFile_t* i_inst);



#endif /* NYLPC_CSDSERCICE_H_ */
