/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
/**
 * このファイルには、パッケージ内のファイルからのみ参照する関数を定義します。
 */
#ifndef NYLPC_PROTECTED_CSDSERVICE_H_
#define NYLPC_PROTECTED_CSDSERVICE_H_
#include "NyLPC_sdfsService.h"

/**
 * ファイルアクセスの占有待ち時間
 */
#define NyLPC_TcSdService_WAIT_ACCESS (100/portTICK_RATE_MS)

/**********************************************************************
 *
 * NyLPC_TcSdService class
 *
 **********************************************************************/

/**　唯一のサービスインスタンス - Single service instance*/
extern NyLPC_TcSdService_t* _NyLPC_TcSdFsService_inst;

/**
 * サービスが初期化済みならtrueです。 - true if service was initialized.
 */
#define NyLPC_TcSdFsService_isInitService() (_NyLPC_TcSdFsService_inst!=NULL)

/**
 * マウントが必要な時だけマウントする関数。 - This function mounts the fatfs when necessary.
 */
NyLPC_TBool NyLPC_cSdService_prepareSD();

#endif /* NYLPC_PROTECTED_CSDSERVICE_H_ */
