/**
 * @file
 * NyLPC_cFormattextReader.h
 * 書式テキストを読み出す為の関数群です。
 *  Created on: 2013/04/20
 *      Author: nyatla
 */
#include "NyLPC_stdlib.h"

#ifndef NYLPC_CFORMATTEXTREADER_H_
#define NYLPC_CFORMATTEXTREADER_H_


/**
 * [a-zA-Z0-9_-]で構成されるワードを取得します。
 * This function peek a word from string.
 * @return
 * size of seeked.
 */
NyLPC_TInt32 NyLPC_cFormatTextReader_readWord(const NyLPC_TChar* buf,const NyLPC_TChar** top);

/**
 * 文字列からIPアドレスを取得します。
 * [:number:]\.[:number:]\.[:number:]\.[:number:]
 * [:number:]は0-255までに制限されます。
 * @return
 * next pointer
 */
NyLPC_TInt32 NyLPC_cFormatTextReader_readIpAddr(const NyLPC_TChar* buf,NyLPC_TUInt8 v[4]);

/**
 * 文字列からMACアドレスを取得します。
 * [:hex:]:[:hex:]:[:hex:]:[:hex:]
 */
NyLPC_TInt32 NyLPC_cFormatTextReader_readMacAddr(const NyLPC_TChar* buf,NyLPC_TUInt8 v[6]);

/**
 * 連続するスペースを読み飛ばします。
 * @return
 * 読み飛ばしたスペース
 */
NyLPC_TInt32 NyLPC_cFormatTextReader_seekSpace(const NyLPC_TChar* s);


#endif /* NYLPC_CFORMATTEXTREADER_H_ */
