<html>
<body>

<?php
require_once("../lib/MiMicPhpApi/MiMic_LPC1769.php");

//テストするサーバのIPアドレス
$IP='192.168.128.39';
//GPIOのOUTPUT PIN設定
$OUTPUT_PIN=array('dir'=>1,'pin'=>array('mode'=>1,'od'=>0));

/**
 * This test sets value 1 to GPIO0.22 . 
 * 
 */
function gpiopin()
{
	global $OUTPUT_PIN,$IP;
	//connect to MCU
	$mcu=new MiMic_LPC1769_Mcu($IP);
	//Get pin instance
	$pin=$mcu->getPin(MiMic_LPC1769::$P0[22],"GPIO");
	//set pin mode
	$pin->setOpt($OUTPUT_PIN);
	//set value
	$pin->setValue(1);
	//show current value
	echo($pin->getValue());
}
/**
 * This test sets value 3 to GPIO pin set.
 */
function gpioport()
{
	global $OUTPUT_PIN,$IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$port=$mcu->getPort(
		array(MiMic_LPC1769::$P0[0],MiMic_LPC1769::$P0[1])
		,"GPIO");
	$port->setOpt($OUTPUT_PIN);
	$port->setValue(3);
	echo($port->getValue());
}
/**
 * This test get values from AD pin set.
 */
function adport()
{
	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$port=$mcu->getPort(
		array(MiMic_LPC1769::$P0[23],MiMic_LPC1769::$P0[24])
		,"AD");
	
	print_r($port->getValues());
}
/**
 * This test get a value from AD pin.
 */
function adpin()
{
	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$pin=$mcu->getPin(MiMic_LPC1769::$P0[23],"AD");
	print_r($pin->getValue());
}
/**
 * This test set a value to PWM pin.
 */
function pwmpin()
{
	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$pin=$mcu->getPin(MiMic_LPC1769::$P2[0],"PWM");
	$pin->setDuty(0.3);
//	print_r($pin->getValue());
}
/**
 * This test sets values to PWM pin set.
 */
function pwmport()
{
	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$port=$mcu->getPort(array(MiMic_LPC1769::$P2[0],MiMic_LPC1769::$P2[1]),"PWM");
	$port->setDutys(array(null,0.1));
//	print_r($pin->getValue());
}
/**
 * This test write and read memory values.
 */
function mem()
{
	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$mem=new MiMic_LPC1769_Memory($mcu);
	$mem->write32(0x20080000,39);
	$mem->write32(0x20080004,array(39,139,239,339));
	$mem->write32(array(0x20080018,0x20080014,0x20080010),array(439,539,639));
	
	print_r($mem->read32(0x20080000));print_r('<br/>');
	print_r($mem->read32(0x20080004,16));print_r('<br/>');
	print_r($mem->read32(array(0x20080018,0x20080014,0x20080010)));print_r('<br/>');
		//	print_r($pin->getValue());
}
/**
 * This test cales the native function by ID.
 */
function ni()
{	global $IP;
	$mcu=new MiMic_LPC1769_Mcu($IP);
	$ni=new MiMic_LPC1769_Ni($mcu);
	//create result value holder.
	$ret=array('stream'=>array());
	//call the native function #0x39000000(echo back). 1 input stream,1output result. 
	$ni->call(0x39000000,array('stream'=>array(31319)),$ret);		
	print_r($ret);print_r('<br/>');
	$ret=array('wm0'=>null,'stream'=>null);//create a result holder.
	$ni->call(0x39000001,array('wm0'=>38),$ret);
	print_r($ret);print_r('<br/>');
}



if(isset($_GET['c'])){
	echo("cmd=".$_GET['c']."<br/>");
	switch($_GET['c']){
	case 'gpiopin':
		gpiopin();
		break;
	case 'gpioport':
		gpioport();
		break;
	case 'adpin':
		adpin();
		break;
	case 'adport':
		adport();
		break;
	case 'pwmpin':
		pwmpin();
		break;
	case 'pwmport':
		pwmport();
		break;
	case 'ni':
		ni();
		break;
	case 'memory':
		mem();
		break;
	default:
		echo("Invalid command");
		break;
	}
}else{
	echo("Please set parametor 'c'");
}

?>
</body>
</html>
