# -*- coding: nil -*-

module Mint::Generator

  #
  # 繁分数の問題を生成するジェネレータ
  #
  # == オプション
  # [_term_number_]
  #   生成する式の項数を１以上の整数で指定します。
  # [_operators_]
  #   使用可能な演算子を指定します。
  #   +, -, * の３種類から使用したいものを配列で指定します。
  # [_numerator_term_min_]
  #   生成する分母の項数の最小値を１以上の整数で指定します。
  # [_numerator_term_max_]
  #   生成する分母の項数の最大値を１以上の整数で指定します。
  #   _numerator_term_min_ より小さい値を指定することはできません。
  # [_denominator_term_min_]
  #   生成する分子の項数の最小値を１以上の整数で指定します。
  # [_denominator_term_max_]
  #   生成する分子の項数の最大値を１以上の整数で指定します。
  #   _denominator_term_min_ より小さい値を指定することはできません。
  #
  class ComplexFractionalArithmetic < Arithmetic

    private

    option :numerator_term_min,   1
    option :numerator_term_max,   1
    option :denominator_term_min, 2
    option :denominator_term_max, 2
    option :operators,            %w[ + - * ]

    # for inner use
    option :numerator_min,   1
    option :numerator_max,   9
    option :denominator_min, 1
    option :denominator_max, 9
    option :minus,           false

    def expression
      result = []
      result << numerator
      result << "(#{denominator})"
      result.join(' / ')
    end

    def operand
      fraction
    end

    [:numerator, :denominator].each do |name|
      define_method(name) do
        result = []
        term_number(name).times do
          result << operand
          result << options[:operators].sample
        end
        result[0..-2].join(' ')
      end
    end
  end
end

