# -*- coding: nil -*-

module Mint::Generator

  #
  # 小数の四則演算を生成するジェネレータ
  #
  # == オプション
  # [_term_number_]
  #   生成する式の項数を１以上の整数で指定します。
  # [_operators_]
  #   使用可能な演算子を指定します。
  #   *, -, *, div の４種類から使用したいものを配列で指定します。
  # [_min_]
  #   生成する式の各項の最小値を０以上の整数で指定します。
  # [_max_]
  #   生成する式の各項の最大値を０以上の整数で指定します。
  #   _min_ よりも小さい値を指定することは出来ません。
  # [_minus_]
  #   真を指定すると、負も値を生成します。
  # [_digits_]
  #   小数第何位までの小数を生成するかを１以上の整数で指定します。
  #
  class DecimalArithmetic < Arithmetic

    private

    option :min,    0
    option :max,    100
    option :minus,  true
    option :digits, 2

    def operand
      decimal
    end
  end
end

