# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 分数の四則演算を生成するジェネレータ
  #
  # == オプション
  # [_term_number_]
  #   生成する式の項数を１以上の整数で指定します。
  # [_operators_]
  #   使用可能な演算子を指定します。
  #   +, -, *, div の４種類から使用したいものを配列で指定します。
  # [_minus_]
  #   真を指定すると、負の値も生成します。
  # [_numerator_min_]
  #   生成する分子の最小値を１以上の整数で指定します。
  # [_numerator_max_]
  #   生成する分子の最大値を１以上の整数で指定します。
  #   _numerator_min_ より小さい値を指定することは出来ません。
  # [_denominator_min_]
  #   生成する分母の最小値を１以上の整数で指定します。
  # [_denominator_max_]
  #   生成する分母の最大値を１以上の整数で指定します。
  #   _denominator_min_ より小さい値を指定することは出来ません。
  #
  class FractionalArithmetic < Arithmetic

    private

    option :minus,           true
    option :numerator_min,   1
    option :numerator_max,   100
    option :denominator_min, 2
    option :denominator_max, 100

    def expression
      return two_term_expression if options[:term_number] == 2
      some_term_expression
    end

    def two_term_expression
      result = []
      result << operand
      result << (operator = options[:operators].sample)
      an, ad = result.first.scan(/(\d+)\/(\d+)/).first.map(&:to_i)
      begin
        numerator   = numerator_part
        denominator = denominator_part
        res_numerator, res_denominator =
          result_parts(
            an, ad,
            numerator, denominator,
            operator
          )
      end while is_lowest_term?(res_numerator, res_denominator)
      result << "(%s/%s)" % [numerator, denominator]
      result.join(' ')
    end

    def result_parts(a, b, c, d, op)
      lcm = b.lcm(d)
      case op
        when '+' then return [a*lcm + c*lcm, lcm]
        when '-' then return [a*lcm - c*lcm, lcm]
        when '*' then return [a * c, b * d]
        when 'div' then return [a * d, b * c]
      end
    end

    def some_term_expression
      result = []
      operator = ''
      options[:term_number].times do
        result << operand
        result << ')' if %w[* div].include? operator
        operator = options[:operators].sample
        result << operator
        result << '(' if %w[* div].include? operator
      end
      # except last operator
      result.pop if result.last == '('
      result[0..-2].join(" ")
    end

    def operand
      fraction
    end
  end
end

