#!/usr/local/bin/wish86

# Copyright: 2012 Miranda-JP Project, All Right Reserved.
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice, this 
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice, 
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE MIRANDA-JP PROJECT ``AS IS'' AND ANY EXPRESS 
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE MIRANDA-JP PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are 
# those of the authors and should not be interpreted as representing official 
# policies, either expressed or implied, of the Miranda-JP Project.
#
package require Tk
package require msgcat

catch [list msgcat::mcload [file dirname $argv0]]; # try to load msg file.

# Variables
set exts [list *.c *.cpp *.cxx *.h *.hxx]; # glob pattern for source files
set path [pwd]; # initial value for target path
set msg [msgcat::mc {Select Source Folder}]; # initial value for message
set files 0; # All files
set success 0; # success files
set failed 0; # failure files
set outside 0; # processed files

# codeMenu -
proc codeMenu {w var} {
    set allEncodings [lsort -dictionary [encoding names]]; # all of possible encoding names
    set defaultEncoding [encoding system]; # sustem encoding as default
    set cmd [list tk_optionMenu $w $var $defaultEncoding];# start of generation
    foreach i $allEncodings {
	if {![string equal $defaultEncoding $i]} {
	    lappend cmd $i; 
	}
    }
    return $cmd; # return code string
}

# expandPath -
proc expandPath {path code mode} {
    global files msg;
    foreach i [glob -nocomplain -- [file join $path *]] {
	if {[file isdirectory $i]} {
	    expandPath $i $code $mode; update
	    continue;
	}
	if {[file isfile $i] && [isFile $i]} {
	    incr files;
	    if {[string length $i] < 32} {
		set fn $i
	    } else {
		set fn [file split $i]
		if {[regexp -- {^([A-Z]\:)/ (.*)$} $fn dummy drive rests]} {
		    set fn "$drive $rests"
		}
		set fn [join "[lrange $fn 0 3] {...} [lindex $fn end]" \
			    [file separator]]
	    }
	    set msg [msgcat::mc "Converting"]:$fn; update
	    doConvertFile $i $code $mode
	}
    }
}

# isFile -
proc isFile {path} {
    global exts
    foreach i $exts {
	if {[string match $i $path]} {
	    return 1
	}
    }
    return 0
}

# doConvertFile
proc doConvertFile {path code mode} {
    global success failed outside
    global msg
    
    if {[catch [list open $path] fp]} {
	incr failed;
	set msg [msgcat::mc "Error: %s" $fp]; update
	return
    }
    fconfigure $fp -encoding binary -translation binary;
    set contents [read $fp];
    catch [list close $fp];

    set isAscii [string is ascii $contents]
    set hasBOM [string match "\xef\xbb\xbf*" $contents]
    if { $isAscii || \
	     ( $hasBOM && ( [string equal "toUTF8" $mode]) || [string equal "ascii" $code] ) || \
	     ( ! $hasBOM && [string equal "fromUTF8" $mode] ) } {
	incr outside;
	return
    }

    if {[catch [list open $path w] fp]} {
	incr failed;
	set msg [msgcat::mc "Error: %s" $fp]; update
	return
    }
    fconfigure $fp -encoding binary -translation binary;

    if {[string equal "toUTF8" $mode]} {
	if {[catch [list puts -nonewline $fp "\xef\xbb\xbf"] err]} {
	    catch [list close $fp];
	    incr failed;
	    set msg [msgcat::mc "Error: %s" $err]; update
	    return
	}
    }

    if {$hasBOM && [string equal "fromUTF8" $mode]} {
	set contents [string range $contents 3 end]
    }

    if {[string equal "toUTF8" $mode]} {
	set incode $code
	set outcode utf-8
    } else {
	set incode utf-8
	set outcode $code
    }
    if {[catch [list puts -nonewline $fp [encoding convertto $outcode [encoding convertfrom $incode $contents]]] err]} {
	    catch [list close $fp];
	    incr failed
	set msg [msgcat::mc "Error: %s" $err]; update
	    return
    }
    if {[catch [list close $fp] err]} {
	incr failed;
	set msg [msgcat::mc "Error: %s" $err]; update
	return
    }
    incr success;
}

label .l -textvariable msg -anchor w
frame .f1
label .f1.l -text [msgcat::mc "Source Folder:"]
entry .f1.e -textvariable path
button .f1.b -text [msgcat::mc "Browse"] -command {
    set path [tk_chooseDirectory -initialdir $path \
		  -title [msgcat::mc "Select Source Folder"]]
    if {[string equal "" $path]} {
	set path [pwd]
    }
}
pack .f1.l -side left
pack .f1.b -side right
pack .f1.e -side bottom -fill x -expand true
frame .f2
label .f2.l -text [msgcat::mc "Convert Charset"]
eval [codeMenu .f2.cm code]
button .f2.exec1 -text [msgcat::mc "to UTF-8 wih BOM"] -command {
    set ret [tk_dialog .d1 [msgcat::mc "Confirm"] \
		 [msgcat::mc "All files under %s with ext %s, Convert charset %s to UTF-8 with BOM, OK?" $path $exts $code] question 0 yes no]
    if {[string equal "0" $ret]} {
	set files 0; set success 0; set failed 0; set outside 0; # initialize
	set msg [msgcat::mc "Converting"]; update
	expandPath $path $code toUTF8
	tk_dialog .d [msgcat::mc "Results"] \
	    [msgcat::mc "All of targets: %s, Success: %s, Fail: %s, out of target: %s" $files $success $failed $outside] info 0 ok 
    }
    set msg [msgcat::mc "Select Source Folder"]
}
button .f2.exec2 -text [msgcat::mc "from UTF-8 with BOM"] -command {
    set ret [tk_dialog .d1 [msgcat::mc "Confirm"] \
		 [msgcat::mc "All files under %s with ext %s, Convert charset from  UTF-8 with BOM to %s, OK?" $path $exts $code] \
		 question 0 yes no]
    if {[string equal "0" $ret]} {
	set files 0; set success 0; set failed 0; set outside 0; # initialize
	set msg [msgcat::mc "Converting"]; update
	expandPath $path $code fromUTF8
	tk_dialog .d [msgcat::mc "Results"] \
	    [msgcat::mc "All of targets: %s, Success: %s, Fail: %s, out of target: %s" $files $success $failed $outside] info 0 ok 
    }
    set msg [msgcat::mc "Select Source Folder"]
}
pack .f2.l -side left -fill y -expand true
pack .f2.cm -side left -fill both -expand true
pack .f2.exec1 .f2.exec2 -side top -fill y -expand true
button .exit -text [msgcat::mc "Exit"] -command {exit}

pack .l -fill both -expand true
pack .f1 .f2 -fill x -expand true 
pack .exit -fill x -expand true
