#pragma once

#include <memory>
#include <string>

class CharacterModelManager
{
public:
    CharacterModelManager();
    ~CharacterModelManager();

    void AddSearchDirectoryPath(const std::string& search_dir_path);
    int GetModelHandle(int model_number);
    std::string GetModelPackageName(int model_number);

    static CharacterModelManager& GetInstance();

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};
