//
// Stage.hpp
//

#pragma once

#include <memory>
#include <DxLib.h>
#include "dx_vector.hpp"

class Stage {
    public:
        Stage(const std::string& model_path, float model_scale);
        void Draw();

        float GetFloorY(const VECTOR& v1, const VECTOR& v2) const;
        std::pair<bool, VECTOR> FloorExists(const VECTOR& foot_pos, float model_height, float collision_depth_limit) const;
        bool IsFlatFloor(const VECTOR& foot_pos, const VECTOR& direction) const;
        bool FrontCollides(float collision_length, const VECTOR& current_pos, const VECTOR& prev_pos,
                float height_begin, float height_end, size_t num_division) const;

        int map_handle() const;
        float map_scale() const;

    private:
        int map_handle_;
        float map_scale_;
};

typedef std::shared_ptr<Stage> StagePtr;

