//
// Config.hpp
//

#pragma once

#include <fstream>
#include <string>
#include <iostream>
#include "unicode.hpp"
#include "ScriptEnvironment.hpp"

class Config
{
    public:
        Config();
        void Load(const std::string&);

    private:
        void Get(const Handle<Object>& object, const std::string& name, int* value);
        void Get(const Handle<Object>& object, const std::string& name, bool* value);
        void Get(const Handle<Object>& object, const std::string& name, std::string* value);

    private:
        bool fullscreen_;
        int screen_width_;
        int screen_height_;
        bool antialias_;
        std::string host_;
        int port_;
        std::string model_dir_;
        int max_script_execution_time_;
        int max_local_storage_size_;
        bool upnp_;
        int udp_port_;

    public:
        bool fullscreen() const;
        int screen_width() const;
        int screen_height() const;
        bool antialias() const;
        std::string host() const;
        int port() const;
        std::string model_dir() const;
        int max_script_execution_time() const;
        int max_local_storage_size() const;
        bool upnp() const;
        int udp_port() const;

};
