//
// Core.hpp
//

#pragma once

#include <DxLib.h>
#include "Config.hpp"
#include "InputManager.hpp"
#include "scene/Include.hpp"
#include "../common/network/Client.hpp"

class Core {

    public:
        Core();
        int Run();

    private:
        void MainLoop();
        int SetUpDxLib();
        void SceneInit();
        void SetScene(scene::BasePtr);

        void LoadFont();

    private:
        Config config_;
        scene::BasePtr current_scene_;
        scene::AccessorPtr accessor_;

    private:
        constexpr const static char* CONFIG_PATH = "config.json";
        constexpr const static TCHAR* WINDOW_TITILE = _T("Miku Miku Online");
        constexpr const static TCHAR* FONT_FILE_PATH = _T("resources/fonts/umeplus-p-gothic.ttf");

    class CoreAccessor : public scene::Accessor {
        public:
            CoreAccessor(Core* core) : core_(core) {}

            virtual void SetScene(scene::BasePtr scene);
            virtual const Config& config();

        private:
            Core* core_;
    };

};
