//
// InputManager.hpp
//

#pragma once

#include <array>

class InputManager {
    public:
        InputManager();
        static void Update();
        void operator&=(const InputManager& input);

        int GetMouseX() const;
        int GetMouseY() const;
        std::pair<int, int> GetMousePos() const;
        int GetMouseWheel() const;

        int GetMouseRightCount() const;
        int GetMouseLeftCount() const;
        int GetMouseMiddleCount() const;

        bool GetMouseRight() const;
        bool GetMouseLeft() const;
        bool GetMouseMiddle() const;

        bool GetPrevMouseRight() const;
        bool GetPrevMouseLeft() const;
        bool GetPrevMouseMiddle() const;

        int GetKeyCount(int) const;

        void CancelMouseWheel();
        void CancelMouseRight();
        void CancelMouseLeft();
        void CancelMouseMiddle();
        void CancelKeyCount(int);
        void CancelKeyCountAll();

    private:
        static int mouse_x_, mouse_y_;
        static int static_mouse_right_count_, static_mouse_left_count_, static_mouse_middle_count_;
        static bool static_mouse_right_, static_mouse_left_, static_mouse_middle_;
        static bool prev_mouse_right_, prev_mouse_left_, prev_mouse_middle_;
        static int static_mouse_wheel_;

        bool mouse_right_, mouse_left_, mouse_middle_;
        int mouse_right_count_, mouse_left_count_, mouse_middle_count_;
        int mouse_wheel_;
        std::array<int, 256> key_count_;

        static std::array<int, 256> static_key_count_;
        static std::array<int, 256> static_key_count_tmp_;

    // キーバインド
    public:
        static int
        KEYBIND_FORWARD,
        KEYBIND_BACK,
        KEYBIND_RIGHT_TRUN,
        KEYBIND_LEFT_TURN,
        KEYBIND_JUMP,
        KEYBIND_CHANGE_SPEED,
        KEYBIND_CHANGE_SPEED2,
        KEYBIND_TAB,
        KEYBIND_SHIFT,
        KEYBIND_RETURN,
        KEYBIND_EXIT,
        KEYBIND_REFRESH,
        KEYBIND_SCRIPT_MODE;
};
