//
// Player.hpp
//

#pragma once

#include <string>
#include <array>
#include <list>
#include <memory>
#include <v8.h>
#include "ui/UILabel.hpp"

using namespace v8;

namespace scene {
    class Main;
};

class ScriptEnvironment;

class PlayerManager;
typedef std::weak_ptr<PlayerManager> PlayerManagerWeakPtr;

class Player;
typedef std::shared_ptr<Player> PlayerPtr;

class Player : public std::enable_shared_from_this<Player> {
    public:
        struct Position {
            float x, y, z, theta;
        };

    public:
        Player(unsigned int id, const PlayerManagerWeakPtr& player_manager = PlayerManagerWeakPtr());
        ~Player();

        void Update();
        void Draw();

    public:
        static PlayerPtr GetPointerFromObj(Handle<Object>);
        Handle<Object> GetJSObject();

    private:
        static void RegisterFunctionTemplate(Handle<FunctionTemplate>& func);
        static Handle<FunctionTemplate> GetFunctionTemplate();
        void UpdatePosition(Object* parent);

    private:
        static Handle<Value> Construct(const Arguments& args);
        static void Dispose(Persistent<Value> handle, void* parameter);

    public:

        unsigned int id() const;
        void set_id(unsigned int id);
        std::string name() const;
        void set_name(const std::string& name);
        std::string trip() const;
        void set_trip(const std::string& trip);
        bool login() const;
        void set_login(bool login);
        int revision() const;
        void set_revision(int revision);
        const Position& position() const;
        void set_position(const Position& pos);

        std::string ip_address() const;
        void set_ip_address(const std::string& ip_address);
        uint16_t udp_port() const;
        void set_udp_port(uint16_t udp_port);

    private:
        static scene::Main* scene_;
        PlayerManagerWeakPtr player_manager_;

        int font_handle_;
        std::array<int, 4> name_tip_image_handle_;
        std::array<int, 9> balloon_base_image_handle_;

        unsigned int id_;
        std::string name_;
        std::string trip_;
        bool login_;
        int revision_;
        Position pos_;

        Persistent<Object> ballon_content_;

        Point balloon_root_point_, balloon_root_point_current_;
        Rect name_tip_rect_, name_tip_rect_current_;

        std::string ip_address_;
        uint16_t udp_port_;


    private:
        constexpr static int BALLOON_BASE_BLOCK_SIZE = 24;
        constexpr static int BALLOON_OFFSET_X = -50;
        constexpr static int BALLOON_MIN_WIDTH = 80;

        constexpr static int NAME_TIP_BASE_BLOCK_SIZE = 12;
        constexpr static int NAME_TIP_MARGIN_SIZE = 6;
};

