//
// ResourceManager.hpp
//

#pragma once

#include <DxLib.h>
#include <string>
#include <array>
#include <vector>
#include <unordered_map>
#include "unicode.hpp"

class ResourceManager {

    // Fonts
    public:
        static int default_font_handle();
        static int default_font_size();

    // Graphics
    public:
        static void ClearCache();
        static int LoadCachedGraph(const std::string&);

        template <std::size_t AllNum>
        static std::array<int, AllNum> LoadCachedDivGraph(const std::string& filename, int XNum, int YNum, int XSize, int YSize)
        {
            std::array<int, AllNum> handles;
            if(div_graph_handles_.find(filename) == div_graph_handles_.end()) {
                if(DxLib::LoadDivGraph(filename.c_str(), AllNum, XNum, YNum, XSize, YSize, handles.data()) == -1){
                    return std::array<int, AllNum>();
                }
                std::vector<int> handle_vector;
                for (auto item : handles) {
                    handle_vector.push_back(item);
                }
                div_graph_handles_[filename] = handle_vector;
            } else {
                const std::vector<int>& handle_vector = div_graph_handles_[filename];
                for (std::size_t i = 0; i < AllNum; i++) {
                    handles[i] = handle_vector[i];
                }
            }

            return handles;
        }

    private:
        static int default_font_handle_;
        static std::unordered_map<std::string, int> graph_handles_;
        static std::unordered_map<std::string, std::vector<int>> div_graph_handles_;

    private:
        constexpr const static TCHAR* CHAT_FONT_NAME = _T("UmePlus P Gothic");
        constexpr static int CHAT_FONT_SIZE = 15;
        constexpr static int CHAT_FONT_THICK = 1;
        constexpr static int CHAT_FONT_TYPE = DX_FONTTYPE_ANTIALIASING;
};
