//
// MMO Client GUI Script
//

// ==MetaData==
//
//	@name テキストチャット
//  @tab チャット
//
// ==/MetaData==

var list;

// チャットメッセージ受信
Network.onReceive = function(info, msg) {
	list.addItem(
		new UI.Label({
			docking: UI.DOCKING_TOP | UI.DOCKING_LEFT,
			text: msg.body,
			bgcolor: "#AFEEEECC",
			width: 0
		})
	);
	if (info.player) {
		info.player.setBalloonContent(
			new UI.Label({
				text: msg.body,
				width: 0
			})
		);
	}
}

Player.onLogin = function(player) {
	list.addItem(
		new UI.Label({
			docking: UI.DOCKING_TOP | UI.DOCKING_LEFT,
			text: player.name() + "さんがログインしました",
			bgcolor: "#AFEEEECC",
			width: 0
		})
	);
}

Player.onLogout = function(player) {
	list.addItem(
		new UI.Label({
			docking: UI.DOCKING_TOP | UI.DOCKING_LEFT,
			text: player.name() + "さんがログアウトしました",
			bgcolor: "#AFEEEECC",
			width: 0
		})
	);
}

// チャットメッセージ送信
InputBox.onEnter = function(text) {
	var msgObject = {body: text};
	Network.sendAll(msgObject);
};

list = new UI.List({
	docking: UI.DOCKING_TOP | UI.DOCKING_LEFT | UI.DOCKING_RIGHT | UI.DOCKING_BOTTOM
});

Card.board.addChild(list);

// b.addItem(l);