//
// Accessor.hpp
//

#pragma once

#include <memory>
#include "../Config.hpp"
#include "../../common/network/client.hpp"

namespace scene {

class Base;
typedef std::unique_ptr<Base> BasePtr;

class Accessor {
    public:
        virtual void SetScene(BasePtr scene) = 0;
        virtual const Config& config() = 0;
};

typedef std::unique_ptr<Accessor> AccessorPtr;

}
