//
// UIButton.hpp
//

#pragma once

#include "UIBase.hpp"
#include <array>
#include <string>

class UIButton : public UIBase {
    public:
        UIButton();
        ~UIButton();
        void ProcessInput(InputManager* input);
        void Update();
        void Draw();

    public:
        static void DefineInstanceTemplate(Handle<ObjectTemplate>* object);

    private:
        std::array<int,4> base_image_handle_;

    private:
        void DrawBase();

    private:
        constexpr static int BASE_BLOCK_SIZE = 12;

};
