//
// UIGroup.cpp
//

/**
* @module global
* @submodule UI
 */

/**
 * @class Group
 *
 * 複数のUI部品を一つにまとめるための部品
 *
 * @namespace UI
 * @extends UI.Base
 */

#include "UIGroup.hpp"
#include "../ScriptEnvironment.hpp"
#include "../ResourceManager.hpp"

UIGroup::UIGroup()
{
}

UIGroup::~UIGroup()
{
}

void UIGroup::DefineInstanceTemplate(Handle<ObjectTemplate>* object)
{
    UIBase::DefineInstanceTemplate(object);

}

void UIGroup::ProcessInput(InputManager* input)
{
    ProcessInputChildren(input);
}

void UIGroup::Update()
{
    UpdatePosition();

    //int max_y = 0;
    for(auto child : children_) {
        UIBasePtr child_ptr = *static_cast<UIBasePtr*>(child->GetPointerFromInternalField(0));
        child_ptr->Update();
        //max_y = std::max(max_y, child_ptr->)
    }
}

void UIGroup::Draw()
{
    if (!visible_) {
        return;
    }
    DrawChildren();
}
