//
// UILabel.hpp
//

#pragma once

#include "UIBase.hpp"
#include <array>
#include <string>

class UILabel : public UIBase {
    public:
        UILabel();
        ~UILabel();
        void ProcessInput(InputManager* input);
        void Update();
        void Draw();

        void set_text(const std::string& text);
        std::string text();

        void set_textcolor(const Color& color);
        Color textcolor() const;
        void set_bgcolor(const Color& color);
        Color bgcolor() const;

    public:
        static void DefineInstanceTemplate(Handle<ObjectTemplate>* object);

    private:
        void UpdatePosition();

    private:
        std::string text_;
        std::vector<int> substr_list_;
        std::vector<int> char_width_list_;
        int font_handle_;

        Color textcolor_, bgcolor_;

    private:
        constexpr static int BASE_BLOCK_SIZE = 12;

};
