//
// Account.hpp
//

#pragma once

#include <string>
#include <sqlite3.h>

typedef long UserID;

class Account {
    public:
        Account(const std::string&);
        ~Account();

        int GetCurrentRevision();
        std::string GetRevisionPatch(int revision);
        void ApplyRevisionPatch(const std::string& patch);

        UserID GetUserId(const std::string&);
        std::string GetPublicKey(UserID);
        UserID RegisterPublicKey(const std::string&);

        std::string GetJSONString();
        void CleanExpired();

        void LogIn(UserID);
        void LogOut(UserID);
        void LogOutAll();

        std::string GetUserName(UserID);
        void SetUserName(UserID, const std::string&);
        std::string GetUserTrip(UserID);
        void SetUserTrip(UserID, const std::string&);
        std::string GetUserIPAddress(UserID);
        void SetUserIPAddress(UserID, const std::string&);
        uint16_t GetUserUDPPort(UserID);
        void SetUserUDPPort(UserID, uint16_t);

    private:
        sqlite3 *db_;
        sqlite3_stmt *stmt_get_current_revision_,
                     *stmt_get_revision_patch_,
                     *stmt_apply_revision_patch_,
                     *stmt_clean_logout_,
                     *stmt_get_user_id_,
                     *stmt_get_public_key_,
                     *stmt_register_public_key_,
                     *stmt_get_json_string_,
                     *stmt_login_,
                     *stmt_logout_,
                     *stmt_logout_all_,
                     *stmt_clean_expired_,
                     *stmt_get_user_name_,
                     *stmt_set_user_name_,
                     *stmt_get_user_trip_,
                     *stmt_set_user_trip_,
                     *stmt_get_user_ip_address_,
                     *stmt_set_user_ip_address_,
                     *stmt_get_user_udp_port_,
                     *stmt_set_user_udp_port_;
};
