//
// CardLibrary.hpp
//

#pragma once

#include <string>
#include <sqlite3.h>

class CardLibrary {
    public:
        CardLibrary(const std::string&);
        ~CardLibrary();

        int Register(const std::string& name,
                     const std::string& note,
                     const std::string& url,
                     int user_id);

        int GetCurrentRevision();
        std::string GetRevisionPatch(int revision);
        void ApplyRevisionPatch(const std::string& patch);

        std::pair<int, std::string> GetWaitingUrl();
        void AcceptUrl(int id, const std::string& finger_print, int size);
        void RejectUrl(int id);

        void Remove(int id);
        int Size();

        enum Status {
            STATUS_CHECKING =       0,
            STATUS_AVAILABLE =      1,
            STATUS_REJECTED =       2,
            STATUS_REMOVED =        3
        };

    private:
        void Initialize(const std::string& logfile);

    private:
        sqlite3 *db_;
        sqlite3_stmt *stmt_register_,
                     *stmt_get_current_revision_,
                     *stmt_get_revision_patch_,
                     *stmt_apply_revision_patch_,
                     *stmt_get_waiting_url_,
                     *stmt_accept_url_,
                     *stmt_reject_url_,
                     *stmt_remove_,
                     *stmt_clean_removed_,
                     *stmt_get_size_;
};
