//
// SystemLog.hpp
//

#pragma once

#include <string>
#include <queue>
#include <sqlite3.h>
#include <boost/thread.hpp>
#include <memory>

class SystemLog {
    public:
        enum Type {
            LOG_INFO, LOG_DEBUG, LOG_WARNING, LOG_ERROR
        };

        SystemLog(const std::string&);
        virtual ~SystemLog();

        void Info(const std::string&);
        void Debug(const std::string&);
        void Warning(const std::string&);
        void Error(const std::string&);

    private:
        void Log(Type, const std::string&);

    private:
        typedef std::tuple<std::string, std::string, std::string> LogTuple;
        std::queue<LogTuple> wait_logs_;
        boost::thread sql_thread_;
        bool thread_active_;

        sqlite3 *db_;
        sqlite3_stmt *stmt_log_;
        boost::mutex mutex_;
};

typedef std::shared_ptr<SystemLog> SystemLogPtr;
typedef std::weak_ptr<SystemLog> SystemLogWeakPtr;
