//
// Config.cpp
//

#include "Config.hpp"

Config::Config(const std::string& filename) :
server_name_("MMO Server"),
port_(39390),
room_capacity_(10),
channel_capacity_(30),
max_total_read_average_(5000),
max_session_read_average_(500),
min_session_read_average_(100)
{
    std::ifstream ifs(filename.c_str());
    picojson::parse(json_, ifs);

    load<std::string>("server_name", server_name_);
    load<double>("port", port_);
    load<double>("room_capacity", room_capacity_);
    load<double>("channel_capacity", channel_capacity_);
    load<double>("max_total_read_average", max_total_read_average_);
    load<double>("max_session_read_average", max_session_read_average_);
    load<double>("min_session_read_average", min_session_read_average_);
    load<std::string>("download_path", download_path_);
    load<std::string>("scan_command", scan_command_);

}

//
// アクセサ
//

const std::string& Config::server_name() const
{
    return server_name_;
}

int Config::port() const
{
    return port_;
}

int Config::room_capacity() const
{
    return room_capacity_;
}

int Config::channel_capacity() const
{
    return channel_capacity_;
}

int Config::max_total_read_average() const
{
    return max_total_read_average_;
}

int Config::max_session_read_average() const
{
    return max_session_read_average_;
}

int Config::min_session_read_average() const
{
    return min_session_read_average_;
}

std::string Config::download_path() const
{
    return download_path_;
}

std::string Config::scan_command() const
{
    return scan_command_;
}
