//
// Input.hpp
//

#pragma once

#include <array>
#include <functional>
#include "../ResourceManager.hpp"
#include "../InputManager.hpp"

class Input {
        typedef std::function<bool(const std::string&)> CallbackFunc;

    public:
        Input();

        void Draw();
        void Update();
        void ProcessInput(InputManager* input);

        std::string GetInputString();

        bool active();
        void set_active(bool flag);

        int x() const;
        void set_x(int x);
        int y() const;
        void set_y(int y);
        int width() const;
        void set_width(int width);
        int height() const;
        void set_height(int height);

        std::string text() const;
        void set_text(const std::string& text);

        std::string message() const;
        void set_message(const std::string& message);

        void set_on_enter(const CallbackFunc& func);

    private:
        void ResetCursorCount();
        void CancelSelect();

    private:
        int x_, y_, width_, height_;
        int cursor_x_, cursor_y_;

        std::array<ImageHandle, 4> input_bg_image_handle_;
        std::array<ImageHandle, 4> ime_image_handle_;

        int input_handle_, font_handle_, font_height_;

        std::vector<std::string> message_lines_;
        std::vector<std::string> lines_;
        std::vector<std::string> candidates_;

        int candidate_x_, candidate_y_;
        int selecting_candidate_, selecting_clause_;
        int cursor_moveto_x_, cursor_moveto_y_;
        int prev_cursor_pos_, cursor_drag_count_;
        int multiline_;

        std::vector<std::pair<int, int>> selecting_lines_;
        std::vector<std::pair<int, int>> clause_lines_;
        std::vector<std::pair<int, int>> selecting_clause_lines_;

        CallbackFunc on_enter_;
        std::string message_;

        int blink_count_;

    private:
        constexpr static size_t HISTORY_MAX_SIZE = 50;

        constexpr static int DEFAULT_MAX_WIDTH = 600;

        constexpr static int BOX_MIN_WIDTH = 200;
        constexpr static int BOX_TOP_MARGIN = 36;
        constexpr static int BOX_BOTTOM_MARGIN = 24;
        constexpr static int BOX_SIDE_MARGIN = 24;

        constexpr static int KEY_REPEAT_FRAME = 6;

        constexpr static int INPUT_MARGIN_X = 8;
        constexpr static int INPUT_MARGIN_Y = 6;

        constexpr static int IME_BLOCK_SIZE = 32;
        constexpr static int IME_MARGIN_BASE = 12;
        constexpr static int IME_MARGIN_Y = 16;
        constexpr static int IME_MAX_PAGE_SIZE = 6;
        constexpr static int IME_MIN_WIDTH = 120;
};
