//
// Stmt.cpp
//

#include "Stmt.hpp"
#include "../Logger.hpp"

namespace SQLite {

Client::Client(const std::string& name)
{
    int result = sqlite3_open(name.c_str(), &db_);
    if (result != SQLITE_OK){
        Logger::Error("Cannot open account data.");
        db_ = nullptr;
    }
}

Client::~Client()
{
    sqlite3_close(db_);
}

int Client::Exec(const std::string& sql)
{
    return sqlite3_exec(db_, sql.c_str(), nullptr, nullptr, nullptr);
}

std::string Client::ErrorMsg() const
{
    return sqlite3_errmsg(db_);
}

sqlite3* Client::db() const
{
    return db_;
}

Stmt::Stmt(const Client& client, const std::string& sql) :
        stmt_(nullptr)
{
    sqlite3_prepare_v2(client.db(), sql.c_str(), -1, &stmt_, nullptr);
}

Stmt::~Stmt()
{
    sqlite3_finalize(stmt_);
}

int Stmt::Step()
{
    return sqlite3_step(stmt_);
}

int Stmt::Reset()
{
    return sqlite3_reset(stmt_);
}

int Stmt::Bind(int column, int value)
{
    return sqlite3_bind_int(stmt_, column, value);
}

int Stmt::Bind(int column, const std::string& value)
{
    return sqlite3_bind_text(stmt_, column, value.data(), value.size(), SQLITE_TRANSIENT);
}

int Stmt::IntValue(int column)
{
    return sqlite3_column_int(stmt_, column);
}

std::string Stmt::TextValue(int column)
{
    return std::string (
            reinterpret_cast<const char*>(sqlite3_column_text(stmt_, column)),
            sqlite3_column_bytes(stmt_, column)
            );
}

} // SQLite
