//
// ChatLog.cpp
//

#include "ChatLog.hpp"
#include "../common/Logger.hpp"

ChatLog::ChatLog(const std::string& logfile) :
db_(nullptr),
stmt_push_(nullptr)
{

    int result = sqlite3_open(logfile.c_str(), &db_);
    if (result != SQLITE_OK){
        Logger::Error("Cannot open chat log.");
        sqlite3_close(db_);
        db_ = nullptr;
    } else {
        const char query[] =
        u8R"(
                CREATE TABLE IF NOT EXISTS "chatlog" (
                    "user_id" INTEGER,
                    "date" TEXT,
                    "message" TEXT
                );
        )"; // ヒアドキュメント

        // テーブルを作成
        char *error = nullptr;
        int result = sqlite3_exec(db_, query, nullptr, nullptr, &error);
        if (result != SQLITE_OK) {
            Logger::Error(error);
        }


        const char query_push[] =
        u8R"(
            INSERT INTO `chatlog`
            (`user_id`, `date`, `message`)
            VALUES(?,?,?)
        )"; // ヒアドキュメント

        sqlite3_prepare(db_, query_push, strlen(query_push), &stmt_push_, nullptr);
    }
}

ChatLog::~ChatLog()
{
    if (db_) {
        sqlite3_finalize(stmt_push_);
        stmt_push_ = nullptr;

        sqlite3_close(db_);
        db_ = nullptr;
    }
}

void ChatLog::Push(Message msg)
{

    list_.push_back(msg);

    boost::mutex::scoped_lock lk(mutex_);

    sqlite3_reset(stmt_push_);

    sqlite3_bind_int(stmt_push_, 1,  static_cast<long>(msg.user_id));
    sqlite3_bind_text(stmt_push_, 2,  msg.date.c_str(), msg.date.size(), SQLITE_STATIC);
    sqlite3_bind_text(stmt_push_, 3,  msg.body.c_str(), msg.body.size(), SQLITE_STATIC);

    // stmtのSQLを実行
    int result, loop=0;
    while (SQLITE_DONE != (result = sqlite3_step(stmt_push_)) && loop++<1000){}
    if (result != SQLITE_DONE) {
        Logger::Error(sqlite3_errmsg(db_));
    }

}

std::list<ChatLog::Message> ChatLog::Load()
{
    return list_;
}
