//
// MMO TestBot
//

//
// Version
const int VERSION[] = {
        0, 1, 0, 0,             // Major
        0, 0, 0, 0              // Minor
};

#include <iostream>
#include <sstream>
#include <ctime>
#include <boost/format.hpp>
#include <boost/thread.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include "../../common/network/Client.hpp"
#include "../../common/database/CardLibrary.hpp"
#include "../Account.hpp"
#include <openssl/rand.h>

using namespace boost::posix_time;

int main(int argc, char* argv[])
{
  try {

      boost::thread t([](){
          std::unique_ptr<network::Client> client;
          network::Encrypter encrypter;

          CardLibrary cardlib(":memory:");
          Account account(":memory:");

          const char host[] = "localhost";
          const unsigned int port = 39390;

          client.reset(new network::Client(
                 host,port,39391,
                 encrypter.GetPublicKey(),
                 encrypter.GetPrivateKey(),
                 "server_key.pub", false));

          if (client) {
              client->Write(network::ServerRequestedCardRevisionPatch(cardlib.GetCurrentRevision()));
              client->Write(network::ServerRequestedAccountRevisionPatch(account.GetCurrentRevision()));
              std::cout << "Send: ServerRequestedCardRevisionPatch" << std::endl;
              std::cout << "Send: ServerRequestedAccountRevisionPatch" << std::endl;
          }

          boost::timer timer;
          while (1) {

              if (client && !client->command_empty())
              {
                  auto command = client->PopCommand();
                  unsigned int header =  command.header();

                  auto text = std::string((boost::format("Receive: 0x%08x %d byte") %
                                           header %
                                           command.body().size()
                                         ).str());
                  std::cout << text << std::endl;

                  switch (header) {
                  using namespace network::header;

                  case ClientReceiveCardRevisionUpdateNotify:
                  {
                      std::tuple<int> result_tuple;
                      network::Utils::Deserialize(command.body(), &result_tuple);
                      auto current_revision = cardlib.GetCurrentRevision();
                      if (std::get<0>(result_tuple) > current_revision) {
                          client->Write(network::ServerRequestedCardRevisionPatch(current_revision));
                      }
                  }
                      break;

                  case ClientReceiveAccountRevisionUpdateNotify:
                  {
                      std::tuple<unsigned int> result_tuple;
                      network::Utils::Deserialize(command.body(), &result_tuple);
                      auto current_revision = account.GetCurrentRevision();
                      if (std::get<0>(result_tuple) > current_revision) {
                          client->Write(network::ServerRequestedAccountRevisionPatch(current_revision));
                      }
                  }
                      break;

                  case ClientReceiveCardRevisionPatch:
                  {
                      //cardlib.ApplyRevisionPatch(command.body());
                  }
                      break;

                  case ClientReceiveAccountRevisionPatch:
                  {
                      //account.ApplyRevisionPatch(command.body());
                  }
                      break;

                  default:
                      break;
                  }

              }

              if (client) {
                  float x = rand() / 1000.0,
                        y = rand() / 1000.0,
                        z = rand() / 1000.0,
                        theta = rand() / 1000.0;
                  client->Write(network::ServerUpdatePlayerPosition(x, y, z, theta));
              }

              if (client && timer.elapsed() >= 5) {

              }

              sleep(1);
          }
      });

      t.join();

  } catch (std::exception& e) {
      std::cout << e.what() << std::endl;
  }

  return 0;
}
