/*******************************************************************************
 * include/elf.h
 *                                                                   2012/09/21
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#ifndef _ELF_H_
#define _ELF_H_

#include <stdint.h>

/* e_identサイズ */
#define EI_NIDENT	16

/* e_identのindex */
#define EI_MAG0		0
#define EI_MAG1		1
#define EI_MAG2		2
#define EI_MAG3		3
#define EI_CLASS	4
#define EI_DATA		5
#define EI_VERSION	6
#define EI_OSABI	7
#define EI_PAD		8

/* ELFマジック */
#define ELFMAG0		0x7F
#define ELFMAG1		'E'
#define ELFMAG2		'L'
#define ELFMAG3		'F'

/* EI_CLASS */
#define ELFCLASS32	1

/* EI_DATA */
#define ELFDATA2LSB	1

/* e_type */
#define ET_EXEC		2

/* e_machine */
#define EM_386		3

/* p_type */
#define PT_LOAD		1

/* p_flags */
#define PF_X		0x1
#define PF_W		0x2
#define PF_R		0x4

/* ELFヘッダ */
typedef struct {
	uint8_t		e_ident[EI_NIDENT];
	uint16_t	e_type;
	uint16_t	e_machine;
	uint32_t	e_version;
	uint32_t	e_entry;
	uint32_t	e_phoff;
	uint32_t	e_shoff;
	uint32_t	e_flags;
	uint16_t	e_ehsize;
	uint16_t	e_phentsize;
	uint16_t	e_phnum;
	uint16_t	e_shentsize;
	uint16_t	e_shnum;
	uint16_t	e_shstrndx;
} ELF32_EHDR;

/* プログラムヘッダ */
typedef struct {
	uint32_t	p_type;
	uint32_t	p_offset;
	uint32_t	p_vaddr;
	uint32_t	p_paddr;
	uint32_t	p_filesz;
	uint32_t	p_memsz;
	uint32_t	p_flags;
	uint32_t	p_align;
} ELF32_PHDR;

#endif
