/*******************************************************************************
 * pbr/pbr.s
 *                                                                   2012/09/22
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
.intel_syntax noprefix
.code16

.global start
.section .text
start:
	/* 初期化 */
	xor		ax, ax
	mov		ds, ax
	mov		es, ax
	mov		ss, ax
	mov		sp, 0x7C00
	
	/* 拡張int0x13の対応確認 */
	mov		ah, 0x41
	mov		dl, 0x80		/* ドライブ番号 */
	mov		bx, 0x55AA
	int		0x13
	cmp		bx, 0xAA55
	jne		failure

	/* booterの読み込み */
	call	read
	
	/* initへ移行 */
	jmp		0:0x8000
	
/* 拡張int0x13による読み込み */
read:
	mov		ax, 0x4200						/* 拡張リード */
	mov		dl, 0x80						/* ドライブ番号 */
	mov		si, offset int0x13_struct		/* 拡張int0x13構造体 */
	int		0x13
	cmp		ah, 0x00
	jne		failure
	ret

/* エラー処理 */
failure:
	mov		si, 0						/* カウンタ */
	mov		bx, 0						/* ページ番号, 文字色 */
	mov		ah, 0x0E					/* 文字出力モード */
failure_1:
	mov		al, [failure_string + si]	/* 文字取得 */
	cmp		al, 0						/* ナル文字チェック */
	je		infinite_loop
	int		0x10
	inc		si
	jmp		failure_1
infinite_loop:
	cli
	hlt
	jmp		infinite_loop
failure_string:
	.asciz	"failed!"

.align 8
	/* 拡張int0x13の構造体 */
int0x13_struct:
	.word	0x0010		/* 構造体サイズ */
	.word	0x0003		/* 読み込むセクタ数 */
	.word	0x0000		/* 読込み先オフセットアドレス */
	.word	0x0800		/* 読込み先セグメントアドレス */
	.word	0x0040		/* 読込み元LBA(0-1バイト) */
	.word	0x0000		/* 読込み元LBA(2-3バイト) */
	.word	0x0000		/* 読込み元LBA(4-5バイト) */
	.word	0x0000		/* 読込み元LBA(6-7バイト) */

	/* ブートシグネチャ */
.org 0x01FE
	.word	0xAA55
