/******************************************************************************/
/* src/kernel/MemMng/MemMngInit.c                                             */
/*                                                                 2017/03/26 */
/* Copyright (C) 2016-2017 Mochi.                                             */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 共通ヘッダ */
#include <stdarg.h>

/* 外部モジュールヘッダ */
#include <Cmn.h>
#include <Debug.h>

/* 内部モジュールヘッダ */
#include "MemMngArea.h"
#include "MemMngGdt.h"
#include "MemMngPage.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* デバッグトレースログ出力マクロ */
#ifdef DEBUG_LOG_ENABLE
#define DEBUG_LOG( ... )                    \
    DebugLogOutput( CMN_MODULE_MEMMNG_INIT, \
                    __LINE__,               \
                    __VA_ARGS__ )
#else
#define DEBUG_LOG( ... )
#endif


/******************************************************************************/
/* グローバル関数定義                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       メモリ管理初期化
 * @details     GDT管理サブモジュールの初期化を呼び出し、メモリ管理機能を初期化
 *              する。
 * 
 * @param[in]   *pMap   メモリマップ
 * @param[in]   mapSize メモリマップサイズ
 */
/******************************************************************************/
void MemMngInit( MochiKernelMemoryMap_t *pMap,
                 size_t                 mapSize )
{
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() start.", __func__ );
    
    /* GDT管理サブモジュール初期化 */
    MemMngGdtInit();
    
    /* メモリ領域管理サブモジュール初期化 */
    MemMngAreaInit( pMap, mapSize );
    
    /* ページ管理サブモジュール初期化 */
    MemMngPageInit();
    
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() end.", __func__ );
    
    return;
}


/******************************************************************************/
