/******************************************************************************/
/* src/booter/Initctrl/InitctrlA20.s                                          */
/*                                                                 2017/03/12 */
/* Copyright (C) 2016-2017 Mochi.                                             */
/******************************************************************************/
 .intel_syntax noprefix
.code16
/******************************************************************************/
/* グローバル宣言                                                             */
/******************************************************************************/
.global A20Enable


/******************************************************************************/
/* TEXTセクション                                                             */
/******************************************************************************/
.section .text
/******************************************************************************/
/* グローバル関数                                                             */
/******************************************************************************/
A20Enable:
    /* A20ライン有効化判定 */
    call        CheckA20
    cmp         ax, 0
    je          A20Enable_0
    
    /* System Port Aを用いて有効化 */
    in          al, 0x92
    or          al, 0x02        /* 有効化                       */
    and         al, 0xFE        /* システムリセットを確実に防ぐ */
    out         0x92, al        /* 設定                         */
    
    /* A20ライン有効化判定 */
    call        CheckA20
    cmp         ax, 0
    je          A20Enable_0
    
    /* キーボードコントローラを用いて有効化 */
    call        waitKBC     /* 入力受付確認   */
    mov         al, 0xD1
    out         0x64, al    /* コマンド書込み */
    call        waitKBC     /* 入力受付確認   */
    mov         al, 0xDF
    out         0x60, al    /* 有効化         */
    call        waitKBC     /* 入力受付確認   */
    
    /* A20ライン有効化判定 */
    call        CheckA20
    cmp         ax, 0
    je          A20Enable_0
    
    /* BIOSを用いて有効化 */
    mov         ax, 0x2401
    int         0x15
    
    /* A20ライン有効化判定 */
    call        CheckA20
    cmp         ax, 0
    je          A20Enable_0
    
A20Enable_0:
    /* A20ライン有効化失敗 */
    mov         ax, -1
    ret
A20Enable_M1:
    /* A20ライン有効化成功 */
    xor         ax, ax
    ret


/******************************************************************************/
/* ローカル関数                                                               */
/******************************************************************************/
CheckA20:
    /* 0xFFFF:0x0010(0x0010_0000)をバックアップ */
    mov         ax, 0xFFFF
    mov         fs, ax
    mov         ax, [ fs:0x0010 ]
    push        ax
    
    /* CPUキャッシング無効化 */
    mov         eax, cr0            /* CR0レジスタ取得              */
    or          eax, 0x40000000     /* CDビットを1に設定            */
    and         eax, 0xD0000000     /* NWビットを0に設定            */
    mov         cr0, eax            /* CR0レジスタに設定して無効化  */
    wbinvd                          /* キャッシュメモリライトバック */
    
    /* 0xFFFF:0x0010(0x0010_0000)に値0xC0DE書き込み */
    mov         word ptr [ fs:0x0010 ], 0xC0DE
    
    /* 0x0000:0x0000(0x0000_0000)の値を読み込む */
    xor         ax, ax
    mov         gs, ax
    mov         bx, [ gs:0x0000 ]
    
    /* 0xFFFF:0x0010(0x0010_0000)をリストア */
    pop         ax
    mov         [ fs:0x0010 ], ax
    
    /* CPUキャッシング有効化 */
    mov         eax, cr0            /* CR0レジスタ取得             */
    or          eax, 0x60000000     /* CD,NWビットを1に設定        */
    mov         cr0, eax            /* CR0レジスタに設定して有効化 */
    
    /* 読み込んだ値と比較 */
    cmp         bx, 0xC0DE
    je          checkA20_M1
    
    /* A20ラインは有効 */
    xor         ax, ax
    ret
checkA20_M1:
    /* A20ラインは無効 */
    mov         ax, -1
    ret

waitKBC:
    /* IBFチェック */
    in          al, 0x64
    test        al, 0x02
    jnz         waitKBC
    ret


/******************************************************************************/
