/******************************************************************************/
/* src/booter/Initctrl/InitctrlCpu.s                                          */
/*                                                                 2017/03/12 */
/* Copyright (C) 2016-2017 Mochi.                                             */
/******************************************************************************/
 .intel_syntax noprefix
.code16
/******************************************************************************/
/* グローバル宣言                                                             */
/******************************************************************************/
.global CpuSwitchMode


/******************************************************************************/
/* TEXTセクション                                                             */
/******************************************************************************/
.section .text

CpuSwitchMode:
    /* 割り込み無効化 */
    mov         al, 0xFF
    out         0xA1, al        /* PIC2割り込み無効化 */
    nop
    out         0x21, al        /* PIC1割り込み無効化 */
    cli                         /* CPU割り込み無効化  */
    
    /* GDT設定 */
    lgdt        [ pGDTR ]
    
    /* CR0レジスタ設定 */
    mov         eax, cr0
    or          eax, 0x00000001 /* PEビットON       */
    mov         cr0, eax        /* 保護モード有効化 */
    
    /* 保護モード移行（far jump） */
    jmp         0x8:setSegment
    
.code32
setSegment:
    /* データセグメント初期化 */
    mov         ax, 2 * 8
    mov         ds, ax
    mov         es, ax
    mov         fs, ax
    mov         gs, ax
    mov         ss, ax
    
    /* スタックポインタ変更 */
    mov         esp, 0x03000000
    
    /* カーネル実行 */
    jmp         0x00100000


/******************************************************************************/
/* DATAセクション                                                             */
/******************************************************************************/
.section .data
/* GDT */
.align 8
pGDT:
    .word   0x0000, 0x0000, 0x0000, 0x0000  /* ナルセグメント   */
    .word   0xFFFF, 0x0000, 0x9800, 0x00CF  /* コードセグメント */
    .word   0xFFFF, 0x0000, 0x9200, 0x00CF  /* データセグメント */

/* GDTR */
pGDTR:
    .word   . - pGDT - 1     /* リミット          */
    .long   pGDT             /* GDTベースアドレス */


/******************************************************************************/
