/******************************************************************************/
/* src/libraries/libc/string/memset.c                                         */
/*                                                                 2017/03/12 */
/* Copyright (C) 2016-2017 Mochi.                                             */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
#include <stdint.h>
#include <string.h>


/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       memset
 * @details     標準Cライブラリのmemset関数。
 * 
 * @param[in]   *s メモリアドレス
 * @param[in]   c  コピー値
 * @param[in]   n  コピーカウント
 * 
 * @retval      メモリアドレス
 * 
 * @attention   引数cはunsigned char型に変換し使用する。
 */
/******************************************************************************/
void *memset( void   *s,
              int    c,
              size_t n   )
{
    /* 1バイト毎に終端バイトから繰り返し */
    while ( n > 0 ) {
        /* コピーカウント更新 */
        n--;
        
        /* コピー値代入 */
        *( ( uint8_t * ) s + n ) = ( uint8_t ) c;
        
    }
    
    return s;
}


/******************************************************************************/
