#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::Atom;
use strict;
use utf8;

use XML::Atom::Feed;
use XML::Atom::Entry;
use XML::Atom::Link;
use POSIX qw/strftime/;

$XML::Atom::DefaultVersion = "1.0";

sub new {
	my ($proto, $cfg) = @_;
	my $class = ref $proto || $proto;
	my $self = {cfg => $cfg, feed => XML::Atom::Feed->new};
	bless $self, $class;

	$self->init();
	return $self;
}

sub init {
	my ($me) = @_;

	$me->{feed}->title($me->{cfg}->{atom}->{title} ? $me->{cfg}->{atom}->{title} : 'unknown');
	$me->{feed}->id($me->{cfg}->{atom}->{id_base});
	$me->{feed}->updated(strftime("%Y-%m-%dT%H:%M:%SZ", gmtime));
	my $author_name = $me->{cfg}->{atom}->{author} ? $me->{cfg}->{atom}->{author} : 'unknown';
	my $author = XML::Atom::Person->new;
	$author->name($author_name);
	$me->{feed}->author($author);

	my $html_link = XML::Atom::Link->new;
	$html_link->type('text/html');
	$html_link->rel('alternate');
	$html_link->href($me->{cfg}->{fb_page_url});
	$me->{feed}->add_link($html_link);

	my $self_link = XML::Atom::Link->new;
	$self_link->type('application/atom+xml');
	$self_link->rel('self');
	$self_link->href($me->{cfg}->{atom}->{url});
	$me->{feed}->add_link($self_link);

	my $hub_link = XML::Atom::Link->new;
	$hub_link->rel('hub');
	$hub_link->href($me->{cfg}->{hub});
	$me->{feed}->add_link($hub_link);

	return $me->{feed};
}

sub add_entry {
	my ($me, $data) = @_;

	my $entry = XML::Atom::Entry->new;
	foreach my $i ('id', 'title', 'content', 'published', 'summary', 'updated') {
		$entry->$i($data->{$i}) if (defined $data->{$i});
	}
	if (defined $data->{author}) {
		my $author = XML::Atom::Person->new;
		$author->name($data->{author});
		$entry->author($author);
	}

	if (defined $data->{link}) {
		my $links = ref $data->{link} eq 'ARRAY' ? $data->{link} : [$data->{link}];
		foreach my $l (@$links) {
			my $link = XML::Atom::Link->new;
			$link->href($l);
			$entry->add_link($link);
		}
	}

	$me->{feed}->add_entry($entry);
	return $me->{feed};
}

sub as_xml {
	my ($me) = @_;
	return $me->{feed}->as_xml;
}

sub print {
	my ($me, $fh) = @_;

	if (defined $fh) {
	    print $fh $me->as_xml;
	} else {
	    print $me->as_xml;
	}
}

1;
