#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::Config;
use strict;
use utf8;

use Config::Any;
use Hash::Merge::Simple;
use Data::Recursive::Encode;

use Data::Dumper;

sub new {
	my ($proto, $config_name) = @_;
	my $class = ref $proto || $proto;
	my $self = {cfg => {}, config_name => $config_name, config_path => ['/etc/mubot4fb/'.$config_name,
									    $ENV{HOME} . '/.mubot4fb/'. $config_name,
									    $ENV{PWD} . '/mubot4fb_' . $config_name]};
	bless $self, $class;

	$self->init();
	return $self;
}

sub init {
	my ($me) = @_;

	my $c = Config::Any->load_stems({stems => $me->{config_path},  use_ext => 1, flatten_to_hash => 1});
	foreach my $i (keys %$c) {
		$me->{cfg} = Hash::Merge::Simple->merge($me->{cfg}, $c->{$i});
	}
	die 'missing config file' unless (keys %{$me->{cfg}});

	$me->{cfg} = Data::Recursive::Encode->decode('utf8', $me->{cfg});

	$me->{cfg}->{irc_port} ||= 6667;
	$me->{cfg}->{irc_channels} ||= ['#mubot4fb'];
	$me->{cfg}->{irc_nick} ||= 'mubot4fb';
	$me->{cfg}->{irc_name}||= $me->{cfg}->{irc_nick};
	$me->{cfg}->{irc_charset} ||= 'utf8';
	$me->{cfg}->{database} ||= 'mubot4fb';
	$me->{cfg}->{debug} ||= 0;

	return $me->{cfg};
}

1;
