#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::FB;
use strict;
use utf8;

use Facebook::Graph;
use LWP::UserAgent;
use HTTP::Request::Common;
use URI::Split qw(uri_split uri_join);

use base 'Mubot4FB::Common';

use Data::Dumper;

sub init {
	my ($me) = @_;
	my $fb = Facebook::Graph->new(app_id   => $me->{cfg}->{fb_app_id},
				      secret   => $me->{cfg}->{fb_app_secret},
				      postback => $me->{cfg}->{fb_postback_url});

	my $res_token = $fb->request_access_token($me->{cfg}->{fb_access_code});
	die 'token get error' if (!defined $res_token || !$res_token->response->is_success);

	my $acts = $fb->fetch('me/accounts');
	die 'can not get account list' if(!defined $acts || !$acts);

	my $page_access_token = '';
	foreach my $d (@{$acts->{data}}) {
		if ($d->{id} eq $me->{cfg}->{fb_page_id}) {
			$page_access_token = $d->{'access_token'};
		}
	}
	die 'can not get access tokenfor page_id=' . $me->{cfg}->{fb_page_id} if ($page_access_token eq '');

	return $me->{fbo} = Facebook::Graph->new(access_token => $page_access_token);
}

sub uri_fixer {
	my ($me, $uri) = @_;

	#dir uri hacks for some buggy host...
	my ($scheme, $auth, $path, $query, $frag) = uri_split($uri);

	if ($auth eq 'www.guardian.co.uk') {
		my @q = split(/&/, $query);
		push(@q, 'fb=optOut');
		$query = join('&',@q);
		$uri = uri_join($scheme, $auth, $path, $query, $frag);
	}

	return $uri;
}

sub publish {
	my ($me, $text, $uri) = @_;

	$uri = $me->uri_fixer($uri);
	return $me->{fbo}->add_post($me->{cfg}->{fb_page_id})
	    ->set_message($text)
	    ->set_link_uri($uri)
	    ->publish()
	    ->as_hashref();
}

sub remove {
	my ($me, $post_id) = @_;

	my $uri = $me->{fbo}->query->find($me->{cfg}->{fb_page_id}.'_'.$post_id)->uri_as_string;
	my $req = HTTP::Request::Common::DELETE($uri);
	warn Dumper($req) if ($me->{cfg}->{debug});
	my $resp;
	$resp = LWP::UserAgent->new->request($req);
	warn Dumper($resp) if ($me->{cfg}->{debug});
	if ($resp->is_success && $resp->code == 200 && $resp->content eq 'true') {
		return 1;
	} else {
		warn 'DELETE ERROR: http code: ' . $resp->code() . ' , http content: ' . $resp->content;
		return 0;
	}
}

1;
