#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::FeedWorker;
use strict;
use utf8;

use base 'Mubot4FB::Common';

use Mubot4FB::Atom;
use POSIX 'strftime';
use Net::PubSubHubbub::Publisher;
use JSON::XS;
use Mubot4FB::DB;
use File::Temp qw/tempfile/;
use File::Copy qw/move/;

use constant DATA_VERSION => '0.1';

use Data::Dumper;

sub init {
	my ($me) = @_;
	$me->{db} = Mubot4FB::DB->new($me->{cfg});
	$me->{pub} = defined $me->{cfg}->{hub} ? Net::PubSubHubbub::Publisher->new(hub => $me->{cfg}->{hub}) : undef;
	return 1;
}

sub work {
	my ($me, $job) = @_;

	my $data = $me->{db}->bulkget_latest();
	my $tmpdir = defined $me->{cfg}->{tmpdir} ? $me->{cfg}->{tmpdir} : '/tmp';

	if (defined $me->{cfg}->{atom}->{path}) {
		my ($fh, $tmp_file) = tempfile("tmpatomXXXXXX", DIR => $tmpdir);
		warn $tmp_file if defined $me->{cfg}->{debug};

		my $feed = Mubot4FB::Atom->new($me->{cfg});
		for my $e (@$data) {
			$feed->add_entry({
				title => $e->{submitter}.'曰く、'.$e->{prefix}.' '.$e->{comment},
				content => $e->{submitter}.'曰く、'.$e->{prefix}.' '.$e->{comment},
				link => $me->post_uri($e->{fb_post_id}),
				id => $me->{cfg}->{atom}->{id_base}.'.'.$e->{fb_post_id},
				author => $e->{submitter},
				published => strftime("%Y-%m-%dT%H:%M:%SZ", gmtime($e->{post_time})),
				updated => strftime("%Y-%m-%dT%H:%M:%SZ", gmtime($e->{post_time})),
					 }
			    );
		}
		$feed->print($fh);
		close($fh);
		move $tmp_file, $me->{cfg}->{atom}->{path} || warn 'can not rename from ' . $tmp_file . ' to ' . $me->{cfg}->{atom}->{path};
		$me->{pub}->publish_update($me->{cfg}->{atom}->{url}) if (defined $me->{pub});
	}

	if (defined $me->{cfg}->{json}->{path}) {
		my $out = {data_version => DATA_VERSION, timestamp => time, data => $data};
		my ($fh, $tmp_file) = tempfile("tmpjsonXXXXXX", DIR => $tmpdir);
		warn $tmp_file if defined $me->{cfg}->{debug};
		print $fh encode_json($out);
		close($fh);
		move $tmp_file, $me->{cfg}->{json}->{path} || warn 'can not rename from ' . $tmp_file . ' to ' . $me->{cfg}->{json}->{path};
	}
}

1;
