﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Twitter;
using WMPLib;

namespace Musitters
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            wmp = new WindowsMediaPlayer();
            wmp.settings.volume = 10;
            wmp.settings.autoStart = false;
            wmp.PlayStateChange += new _WMPOCXEvents_PlayStateChangeEventHandler(PlayStateChange);
            _form1Instance = this;

            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]) && !string.IsNullOrEmpty((string)settings["MusicFolderPath"]))
            {
                ArrayList al = new ArrayList();
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.mp3", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.wav", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.wma", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.3gp", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.aac", ref al);
                this.musicFileList = al;
                this.nowPlayTimes = settings.Level;
            }
            else
            {
                form2 = new Form2();
                form2.Show();
            }

        }

        private Form2 form2;

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }

        public WindowsMediaPlayer wmp;
        private MusicFile mf;
        private ArrayList al = new ArrayList();
        private int nowPlayTimes = 0;
        private bool shouldPlay = false;

        public int NowPlayTimes
        {
            set { this.nowPlayTimes = value; }
            get { return this.nowPlayTimes; }
        }

        public ArrayList musicFileList
        {
            set { this.al = value; }
            get { return this.al; }
        }

        public void GetAllFiles(
            string folder, string searchPattern, ref ArrayList files)
        {
            //folderにあるファイルを取得する
            string[] fs =
                System.IO.Directory.GetFiles(folder, searchPattern);
            //ArrayListに追加する
            files.AddRange(fs);

            //folderのサブフォルダを取得する
            string[] ds = System.IO.Directory.GetDirectories(folder);
            //サブフォルダにあるファイルも調べる
            foreach (string d in ds)
                GetAllFiles(d, searchPattern, ref files);
        }

        public void PlayStateChange(int newState)
        {
            if (wmp.playState == WMPPlayState.wmppsMediaEnded)
            {
                this.shouldPlay = true;
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            form2 = new Form2();
            form2.Show();
        }

        //フォームのCreateParamsプロパティをオーバーライドする
        protected override CreateParams CreateParams
        {
            [System.Security.Permissions.SecurityPermission(
                System.Security.Permissions.SecurityAction.LinkDemand,
                Flags = System.Security.Permissions.SecurityPermissionFlag.UnmanagedCode)]
            get
            {
                const int WS_EX_TOOLWINDOW = 0x80;
                const long WS_POPUP = 0x80000000L;
                const int WS_VISIBLE = 0x10000000;
                const int WS_SYSMENU = 0x80000;
                const int WS_MAXIMIZEBOX = 0x10000;

                CreateParams cp = base.CreateParams;
                cp.ExStyle = WS_EX_TOOLWINDOW;
                cp.Style = unchecked((int)WS_POPUP) |
                    WS_VISIBLE | WS_SYSMENU | WS_MAXIMIZEBOX;
                cp.Width = 0;
                cp.Height = 0;

                return cp;
            }
        }

        private void 再生ToolStripMenuItem_Click(object sender, EventArgs e)
        {

            if (wmp.playState == WMPPlayState.wmppsPaused)
            {
                wmp.controls.play();
            }
            else
            {
                randomMusicPlay();
            }
            this.再生ToolStripMenuItem.Visible = false;
            this.一時停止ToolStripMenuItem.Visible = true;
        }

        private void randomMusicPlay()
        {

            Random r = new Random();
            int nextMusicNum = r.Next(0, al.Count);

            wmp.URL = (string)al[nextMusicNum];
            this.mf = new MusicFile((string)al[nextMusicNum]);

            string tc;
            if (mf.Artist != "")
            {
                tc = mf.Title + " / " + mf.Artist;
            }
            else
            {
                tc = mf.Title;
            }

            this.nowPlayTimes += 1;

            try
            {
                if (99999 < this.nowPlayTimes)
                {
                    MessageBox.Show("おめでとうございます。このシステムの最大レベルに到達しました。");
                    tweet("おめでとうございます。このシステムの最大レベルに到達しました。 #musitters #maxlevel");
                    this.nowPlayTimes = 1;
                }

                if (102 < tc.Length)
                {
                    tweet(tc.Substring(0, 102) + "... #NowPlaying #musitters #" + "level" + this.nowPlayTimes);
                }
                else
                {
                    tweet(tc + " #NowPlaying #musitters #" + "level" + this.nowPlayTimes);
                }
            }
            catch (System.Net.WebException we)
            {
                this.nowPlayTimes += 1;
                //バルーンヒントのタイトル
                notifyIcon1.BalloonTipTitle = "ツイート失敗";
                //バルーンヒントに表示するメッセージ
                notifyIcon1.BalloonTipText = tc + " - Now Playing";
            }

            if (36 < mf.Title.Length)
            {

                notifyIcon1.Text = mf.Title.Substring(0, 46) + "... - Now Playing";
            }
            else
            {
                notifyIcon1.Text = mf.Title + " - Now Playing";
            }

            //バルーンヒントのタイトル
            notifyIcon1.BalloonTipTitle = "ツイート完了 レベル" + this.nowPlayTimes + "になりました";
            //バルーンヒントに表示するメッセージ
            notifyIcon1.BalloonTipText = tc + " - Now Playing";
            //バルーンヒントに表示するアイコン
            notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
            //バルーンヒントを表示する
            //表示する時間をミリ秒で指定する
            notifyIcon1.ShowBalloonTip(1000);
            var settings = Properties.Settings.Default;
            settings.Level = this.nowPlayTimes;
            settings.Save();
            wmp.controls.play();
        }

        private void tweet(string text)
        {

            Dictionary<string, string> parameters = new Dictionary<string, string>();

            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("https://api.twitter.com/1.1/statuses/update.json", parameters);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]) && !string.IsNullOrEmpty((string)settings["MusicFolderPath"]))
            {
                this.再生ToolStripMenuItem.Enabled = true;
            }
            else
            {
                this.再生ToolStripMenuItem.Enabled = false;
            }

            if (shouldPlay)
            {
                randomMusicPlay();
                if (wmp.playState == WMPPlayState.wmppsPlaying || wmp.playState == WMPPlayState.wmppsTransitioning)
                {
                    shouldPlay = false;
                }
            }
        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Application.Exit();
        }

        private void 一時停止ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            wmp.controls.pause();
            this.再生ToolStripMenuItem.Visible = true;
            this.一時停止ToolStripMenuItem.Visible = false;
        }

        private void notifyIcon1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                if (!this.再生ToolStripMenuItem.Enabled) return;
                if (this.再生ToolStripMenuItem.Available)
                {
                    if (wmp.playState == WMPPlayState.wmppsPaused)
                    {
                        wmp.controls.play();
                    }
                    else
                    {
                        randomMusicPlay();
                    }
                    this.再生ToolStripMenuItem.Visible = false;
                    this.一時停止ToolStripMenuItem.Visible = true;
                }
                else
                {
                    wmp.controls.pause();
                    this.再生ToolStripMenuItem.Visible = true;
                    this.一時停止ToolStripMenuItem.Visible = false;
                }
            }
        }

    }
}
