﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;

namespace Musitters
{
    public partial class Form2 : Form
    {
        public Form2()
        {
            InitializeComponent();
            _form2Instance = this;
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                this.label3.Text = (string)settings["ScreenName"];
                this.button3.Text = "認証解除(&A)";
            }
            if (!string.IsNullOrEmpty((string)settings["MusicFolderPath"]))
            {
                label1.Text = (string)settings["MusicFolderPath"];
            }

        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form2 _form2Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form2 Form2Instance
        {
            get
            {
                return _form2Instance;
            }
            set
            {
                _form2Instance = value;
            }
        }

        private WMPLib.WindowsMediaPlayer wmp = new WMPLib.WindowsMediaPlayer();

        private void button3_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;

            if (string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                Form3 form = new Form3();
                form.Show();
            }
            else
            {
                button3.Text = "認証する(&A)...";
                settings.AccessToken = "";
                settings.AccessTokenSecret = "";
                settings.UserId = "";
                settings.ScreenName = "";
                settings.Save();
                label3.Text = "";
            }

        }

        private void button1_Click(object sender, EventArgs e)
        {
            //FolderBrowserDialogクラスのインスタンスを作成
            FolderBrowserDialog fbd = new FolderBrowserDialog();

            //上部に表示する説明テキストを指定する
            fbd.Description = "フォルダを指定してください。";
            //ルートフォルダを指定する
            //デフォルトでDesktop
            fbd.RootFolder = Environment.SpecialFolder.Desktop;
            //最初に選択するフォルダを指定する
            //RootFolder以下にあるフォルダである必要がある
            //fbd.SelectedPath = @"C:\";
            //ユーザーが新しいフォルダを作成できるようにする
            //デフォルトでTrue
            fbd.ShowNewFolderButton = true;

            //ダイアログを表示する
            if (fbd.ShowDialog(this) == DialogResult.OK)
            {
                try
                {
                    ArrayList al = new ArrayList();
                    this.GetAllFiles(fbd.SelectedPath, "*.mp3", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.wav", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.wma", ref al);

                    if (al.Count == 0)
                    {
                        MessageBox.Show("選択したフォルダに音楽ファイルが見つかりませんでした。別のフォルダを選択してください。");
                    }
                    else
                    {
                        Form1.Form1Instance.musicFileList = al;
                        //選択されたフォルダを表示する
                        var settings = Properties.Settings.Default;
                        settings.MusicFolderPath = fbd.SelectedPath;
                        settings.Save();
                        this.label1.Text = fbd.SelectedPath;
                        Form1.Form1Instance.再生ToolStripMenuItem.Enabled = true;
                    }

                }
                catch (UnauthorizedAccessException ex)
                {
                    MessageBox.Show("フォルダのアクセスが拒否されました。別のフォルダを選択してください。");
                }
            }

        }

        private void GetAllFiles(
            string folder, string searchPattern, ref ArrayList files)
        {
            //folderにあるファイルを取得する
            string[] fs =
                System.IO.Directory.GetFiles(folder, searchPattern);
            //ArrayListに追加する
            files.AddRange(fs);

            //folderのサブフォルダを取得する
            string[] ds = System.IO.Directory.GetDirectories(folder);
            //サブフォルダにあるファイルも調べる
            foreach (string d in ds)
                GetAllFiles(d, searchPattern, ref files);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void webBrowser1_Navigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            if (webBrowser1.Url.ToString() != "http://www.momen-yugioh.org/ads/musitters_ads.html")
            {
                Process.Start(webBrowser1.Url.ToString());
                webBrowser1.Url = new Uri("http://www.momen-yugioh.org/ads/musitters_ads.html");
            }
        }

    }
}
