﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EditFavorite
{
    public partial class EditableWindow
    {
        
        private void BuildMenu()
        {
            //お気に入り編集ウィンドウが、×ボタンで閉じられたとき、tagデータが更新されない
            //保存するボタンをクリックした場合は、tagにデータがセットされている。
            if (this.RootMenu.Tag == null)
                return;


            //ルートメニューアイテムtagを元にしてメニューを構築
            object[] arg = (object[])RootMenu.Tag;

            //この形式でセットされている前提
            //List<TreeNode> list = get_AllTreeNode(this.treeView1.Nodes[0]);
            //this.favorites.Tag = new object[] { list , this.writeProtectItems };
            var newRootmenu = MakeMenu((List<TreeNode>)arg[0], (Dictionary<string, ToolStripMenuItem>)arg[1]);

            //いったん配列にしてから、ルートメニューに登録する
            ToolStripItem[] newDropDownItems = new ToolStripItem[newRootmenu.DropDownItems.Count];
            newRootmenu.DropDownItems.CopyTo(newDropDownItems , 0);
            RootMenu.DropDownItems.Clear();
            RootMenu.DropDownItems.AddRange(newDropDownItems);

            
        }//method


        /// <summary>
        /// メニューを構築する
        /// </summary>
        /// <param name="obj">構築するためのソース
        /// 配列の１つめは、アイテム情報（string)
        /// 配列の２つめは、上書き禁止のアイテムの一覧</param>
        /// <param name="delim">アイテム情報区切り</param>
        /// <param name="eventhandler">クリック時のイベントハンドラ</param>
        /// <param name="separatorConst">アイテム情報内でのセパレータの表現</param>
        /// <returns>構築後のメニューアイテム</returns>
        private ToolStripMenuItem MakeMenu(List<TreeNode> list , Dictionary<string , ToolStripMenuItem> wProtectItems )
        {
            if (list == null || wProtectItems == null)
            {
                throw new Exception("メニューアイテム情報が設定されていません");
            }

            var itemList = new Dictionary<string , object>();
            ToolStripMenuItem newRootmenu = null;
            int sepCount = 0;

            //まず、階層は考慮せずに、ToolStripMenuItemを作成
            //foreach (var s in src.Split(new string[] { Environment.NewLine } , StringSplitOptions.RemoveEmptyEntries))
            foreach (TreeNode s in list)
                {



                //入れ物を準備しておく。
                //作成するアイテムは以下のいずれか
                ToolStripSeparator Separator = null;
                ToolStripMenuItem menu = null;

                //表示名（TreeNodeのText）
                var itemname = s.Text;

                //セパレーター表現する文字（------）なら、セパレータ作成
                if (itemname == separatorConst)
                {
                    Separator = new ToolStripSeparator();
                    sepCount++;
                }
                else
                {
                    //書き込み禁止アイテムの名前と同じ指定かチェックし、
                    //ヒットしたら、新規アイテム作成ではなく、
                    //保持していたリストから、コピーする
                    if (wProtectItems.Keys.Contains(itemname))
                    {
                        menu = wProtectItems[itemname];
                        wProtectItems.Remove(itemname);
                    }
                    else
                    {
                        menu = new ToolStripMenuItem(itemname);
                        //渡されたハンドラを登録する
                        menu.Click += Handler;
                    }
                }//if

                //この前のブロックで、メニューかセパレーターがセットされている。
                if (menu != null)
                {
                    //ルート設定（￥が含まれていないもの）
                    if (s.FullPath.Contains(@"\") == false)
                    {
                        newRootmenu = menu;
                    }

                    //メニュー（フォルダ、セパレータ以外）には、タグが設定されているはず。
                    //ツリーノードのタグをそのままセットする（フォルダ、セパレータはNull）
                    //リストに追加しておく。キーはアイテムのフルパス
                    menu.Tag = s.Tag;
                    itemList.Add(s.FullPath, (ToolStripItem)menu);
                }
                else if (Separator != null)
                {
                    //キーが重複しないように細工する
                    //※セパレータは同じ階層に複数存在しうるため
                    itemList.Add(s.FullPath + sepCount.ToString(), (ToolStripItem)Separator);
                }

            }//foreach

            //ここまでで、各アイテムが作成され、リストに登録されている
            //階層を構築する
            foreach (var item in itemList)
            {
                //構築するアイテムは以下のいずれか
                ToolStripSeparator Separator = null;
                ToolStripMenuItem menu = null;

                if (item.Value is ToolStripMenuItem)
                {
                    menu = (ToolStripMenuItem)item.Value;
                }
                else if (item.Value is ToolStripSeparator)
                {
                    Separator = (ToolStripSeparator)item.Value;
                }

                if (item.Key.Contains(@"\"))
                {
                    //aaa\bbb\cccというメニューがあるとしたら、
                    //リストにはaaa,aaa\bbbというフォルダも登録されている
                    //cccをaaa\bbbのDropDownItemsに登録してやることで、階層を構築する
                    //※aaa\bbbもaaaのDropDownItemsに登録する必要があるが、順番は影響しない
                    string s = item.Key.Substring(0 , item.Key.LastIndexOf(@"\"));
                    ((ToolStripMenuItem)itemList[s]).DropDownItems.Add((menu != null) ? (ToolStripItem)menu : (ToolStripItem)Separator);
                }
                else
                {
                    //ルートを自身に追加するとエラーとなる
                    ////newRootmenu.DropDownItems.Add(temp);
                }
            }//foreach

            return newRootmenu;
        }//method MakeMenu













    }//class
}//namespace